<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\util;

//WARNING: SMTAttributeInfosAnnotation is managed outside namespace to avoid to have to put the full qualified name in the name of the annotation
require_once 'app/util/SMTAttributeInfosAnnotation.php';
//WARNING : Addedum annotation are managed outside namespace
require_once 'lib/addendum/annotations.php';

/**
 * Base class for all data objects (DTO). 
 * Dto classes can be exchanged with the client application.
 * They can be serialized/deserialized as/from json string.
 * 
 * @author Sylvain Desplat
 */
abstract class SMTDto implements SMTIDto
{
    const JSON_SERALIZER_METHOD = 'getJsonData';    
    
    /**
     * Serialize as Json data (array) an object which is a property of the current instance.<br> 
     * That method is recursively called by getJsonData();
     * 
     * @param var $objectProperties array of defined object accessible non-static properties
     */
    function serializeObjectAsJsonData( &$objectProperties )
    {        
        //serialize object
        self::serializeObject( $objectProperties );
    }
    
    /**
     * Serialize as Json data object properties.<br>
     * That method is recursively called by itself;
     *
     * @param var $objectProperties array of defined object accessible non-static properties
     */
    private static function serializeObject( &$objectProperties )
    {
    	//serialize object
    	foreach( $objectProperties as &$property )
    	{
    		//if object property is also an object, serialize it as Json data
    		if( is_object($property) && method_exists( $property, SMTDto::JSON_SERALIZER_METHOD ) )
    		{
    			$property = $property->getJsonData();
    		}
    		//check that there is no object to serialize in the array
    		else if ( is_array( $property ) )
    		{
    		    self::serializeObject( $property );
    		}
    		//else
    		//nothing todo, objectProperties don't contain any object to turn into an array
		}		 
	}        
}

?>