<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper;

use app\parser\SMTOtuSocket;
use app\http\SMTContext;

/**
 * 
 * @author Sylvain Desplat
 *
 */
abstract class SMTServiceHelper
{
    /**
     * var app\http\SMTContext
     */
    private $context = NULL;    
    
    function setContext( SMTContext $context )
    {
    	$this->context = $context;
    }
    
    /**
     * @return SMTContext
     */
    function getContext()
    {
    	return $this->context;
    }
    
    /**
     * Shortcut to send receive socket command
     *
     * @param boolean $removeQuotes TRUE by default: remove double quotes from returned string
     *
     * @return the result of the command.
     */
    function sendReceive( $command, $removeQuotes = TRUE )
    {
    	return $this->context->getOtuSocket()->sendReceive( $command, SMTOtuSocket::DEFAULT_SLEEP, SMTOtuSocket::TIME_OUT_READING, $removeQuotes );
    }
    
    /**
     * Shortcut to send receive socket command
     *
     * @return the result of the command.
     */
    function send( $command )
    {
        $this->context->getOtuSocket()->send( $command );
    }            
}
?>