
from viavi.qrcodegen.cdm_proxy import CdmProxy
from .olts_builder import VzOltsBuilder, VzJsonLite
from .otdr_builder import VzOtdrBuilder


class VzQrCdmFactory:
    def __init__(self, cdm: CdmProxy):
        self._cdm = cdm

    def create_json_lite(self) -> VzJsonLite:
        if self._cdm.test_type == "bidirIlOrl":
            builder = VzOltsBuilder(self._cdm)

        elif self._cdm.test_type == "OTDR":
            builder = VzOtdrBuilder(self._cdm)

        else:
            raise TypeError

        builder.produce_root_layer()
        builder.produce_sub_layers()
        builder.post_process()

        json_lite = builder.get_json_lite()

        return json_lite
