

from json import dumps


class VzJsonLite:
    def __init__(self) -> None:
        self.data = dict()
        self.format = None
        self.__compress_format = list()

    def set_compress_format(self, compress_format: list) -> None:
        if type(compress_format) != list:
            raise TypeError

        if self.__compress_format is not compress_format:
            self.__compress_format = compress_format

    def compress(self) -> str:
        str_data = dumps(self.data, separators=(',', ':'))

        for old, new in self.__compress_format:
            str_data = str_data.replace(old, new)

        return str_data


