

ABRIDGMENTS = [
    ("GlobalVerdict", "GlobalVD"),
    ("Hardware", "HW"),
    ("UnitA", "UA"),
    ("UnitB", "UB"),
    ("LastCalibrationDate", "LCAD"),
    ("ModelName", "MN"),
    ("SerialNumber", "SN"),
    ("SchemaVersion", "SV"),
    ("LastChangeDate", "LCD"),
    ("Measurements", "MEAS"),
    ("Identifiers", "IDS"),
    ("Length", "LEN"),
    ("Results", "RES"),
    ("Wavelength", "WA"),
    ("TestDateTime", "TDT")
]


_ROOT_SCHEMA = {
    "GlobalVerdict": "$.tests.0.results.status",
    "Hardware": {
        "UnitA": {
            "LastCalibrationDate": "$.assetInfo.calibrationDate",
            "ModelName": "$.assetInfo.model",
            "SerialNumber": "$.assetInfo.uniqueId"
        },
        "UnitB": {
            "LastCalibrationDate": "",
            "ModelName": "",
            "SerialNumber": ""
        }
    },
    "Identification": {
        "JobId": "$.workflow.workOrderId"
    },
    "SchemaVersion": "1.0",
    "LastChangeDate": "",
    "TestDateTime": "$.tests.0.results.testTime"
}


_TESTS_SCHEMA = {
    "Tests": []
}


_TEST_SCHEMA = {
    "Type": "$.tests.{}.type",
    "Identifiers": "",
    "DistanceUnits": "$.tests.{}.results.data.otdrResults.distanceUnits"
}


_RESULTS_SCHEMA = {
    "Results": []
}

_RESULT_SCHEMA = {
    "Status": "$.tests.{}.results.data.otdrResults.measuredResults.{}.status",
    "Length": "$.tests.{}.results.data.otdrResults.measuredResults.{}.fiberLength",
    "Loss": "$.tests.{}.results.data.otdrResults.measuredResults.{}.linkLossdB",
    "Orl": "$.tests.{}.results.data.otdrResults.measuredResults.{}.linkOrldB",
    "Wavelength": "$.tests.{}.results.data.otdrResults.measuredResults.{}.wavelengthNm"
}


_EVENT_SCHEMA = {
    "Distance": "$.tests.{}.results.data.otdrResults.measuredResults.{}.events.{}.distance",
    "Loss": "$.tests.{}.results.data.otdrResults.measuredResults.{}.events.{}.lossdB",
    "Reflectance": "$.tests.{}.results.data.otdrResults.measuredResults.{}.events.{}.reflectancedB",
    "Slope": "$.tests.{}.results.data.otdrResults.measuredResults.{}.events.{}.slopedB"
}


SCHEMAS = {
    'root': _ROOT_SCHEMA,
    'tests': _TESTS_SCHEMA,
    'test': _TEST_SCHEMA,
    'results': _RESULTS_SCHEMA,
    'result': _RESULT_SCHEMA,
    'event': _EVENT_SCHEMA
}

