import os
import datetime

class Logger(object):
    '''
    Class use to create a log file
    '''

    def __init__(self, fname):
        self.__file = open(fname, "a")
        self.__file.write("______%s_Open log_______\n" % datetime.datetime.now().strftime('%Y-%m-%d-%H-%M-%S'))

    def close(self):
        self.__file.write("______%s_Close log_______\n" % datetime.datetime.now().strftime('%Y-%m-%d-%H-%M-%S'))
        self.__file.close()

    def log(self, line):
        self.__file.write("%s\n" % line.strip())

    @classmethod
    def create(cls, fname):
        if "logger" not in __builtins__.keys():
            __builtins__["logger"] = cls(fname)
        return __builtins__["logger"]
