"""
Module handles sending notification of Jobs received from Mobile Tech to
appropriate service

and all instrument-specific implementation for the workflow endpoint
"""
import logging
import os
import json

from rest_api.products.mts_services.SCPI_Socket import SCPI_Socket
from rest_api.api.job_manager.cdm_schemas_viavi import make_cdm_schema

log = logging.getLogger(__name__)

JOB_MANAGER_DIR = '/user/disk/job-manager/'
JOB_FILE_EXT = '.job.json'
TEMPLATE_FILE_EXT = '.tpl.json'

def get_job_dir():
    return JOB_MANAGER_DIR

def get_job_extension():
    return JOB_FILE_EXT

def get_template_extension():
    return TEMPLATE_FILE_EXT

def notify_job_received( file_path, job_type ):
    """
    Sends a message to the instrument's job manager service about received workflow Jobs
    
    In MTS/T-BERD case, this means tell ISU to load a Job and kick-off Wrapper translations for this Job


    Args:
        

    Returns:
        True if the request was ack'd
    """

    log.debug('## notify_job_received: %s,%s', file_path, job_type )

    ISU = SCPI_Socket('127.0.0.1',8000)
    ISU.debug_level(1)
    ISU.send("*rem")

    success = ISU.send('workflow:newjob "%s",%s' %( file_path, job_type ))

    ISU.close()

    return success



def get_workorder_id_list():
    """
    Gets the list of all work orders (aka Jobs) on the instrument
    
    (for MTS/T-BERD family)

    Args:
        
    Returns:
        
    """

    job_list = []

    #job_dir = get_job_dir()
    #top_schema = make_cdm_schema()
    
    #for filename in os.listdir(job_dir):
    #    if (filename.endswith(get_job_extension())):
    #        try:
    #            with open(os.path.join(job_dir, filename)) as workflow_file:
    #                workflow_json_string = workflow_file.read()

    #            cdm_job = top_schema().loads(workflow_json_string).data
            
    #            for cdm in cdm_job['cdm']:
    #                workorder_id = cdm['workflow']['workorder_id']
    #                job_list.append(workorder_id)

    #        except:
    #            log.debug('## get_workorder_id_list ERROR: skipped {}'.format(filename))



    return job_list



def get_template_list():
    """
    Gets the list of all Job templates on the instrument
    
    (for MTS/T-BERD family)

    Args:
        
    Returns:
        
    """

    template_list = []

    #job_dir = get_job_dir()


    
    #for filename in os.listdir(job_dir):
    #    if (filename.endswith(get_template_extension())):
    #        try:
    #            with open(os.path.join(job_dir, filename)) as template_file:
    #                template_list.append(json.loads(template_file.read()))

    #        except:
    #            log.debug('## get_template_list ERROR: skipped {}'.format(filename))




    return template_list


def get_workorder(workorder_id_param):
    """
    Gets the content of a specific Work Order (aka Job)
    
    (for MTS/T-BERD family)

    Args:
        
    Returns:
        
    """

    workorder = {}
    
    #job_dir = get_job_dir()

    #top_schema = make_cdm_schema()

    #for filename in os.listdir(job_dir):
    #    if (filename.endswith( JOB_FILE_EXT )):
    #        try:
    #            file_path = os.path.join(job_dir, filename)
    #            with open(file_path) as workflow_file:
    #                workflow_json_string = workflow_file.read()

    #            cdm_job = top_schema().loads(workflow_json_string).data
            
    #            for cdm in cdm_job['cdm']:
    #                workorder_id = cdm['workflow']['workorder_id']
    #                if (workorder_id == workorder_id_param):
    #                    workorder = cdm_job
    #                    break

    #        except:
    #            log.debug('## get_workorder ERROR: skipped {}'.format(workorder_id_param))



    return workorder


def set_active_workorder(active_workorder_json_param):
    """
    Sets the active work order (Job) on the instrument
    
    (for MTS/T-BERD family)

    Args:
        
    Returns:
        
    """

    job_set = False
    #job_dir = get_job_dir()
    
    #top_schema = make_cdm_schema()

    #for filename in os.listdir(job_dir):
    #    if (filename.endswith(get_job_extension())):
    #        try:
    #            file_path = os.path.join(job_dir, filename)
    #            with open(file_path) as workflow_file:
    #                workflow_json_string = workflow_file.read()

    #            cdm_job = top_schema().loads(workflow_json_string).data
            
    #            for cdm in cdm_job['cdm']:
    #                workorder_id = cdm['workflow']['workorder_id']
    #                if (workorder_id == active_workorder_json_param['activeWorkOrderId']):
    #                    job_set = True
    #                    notify_job_received( file_path )
    #                    break

    #        except:
    #            log.debug('## get_workorder ERROR: skipped {}'.format(workorder_id_param))
    
    return job_set


def get_active_workorder():
    """
    Get the active Job's Work Oder Id
    (only if something specific needed for MTS/T-BERD family)

    Args:
        
    Returns:
        
    """

    active_workorder = 'Not instrument-specific'

    #job_dir = get_job_dir()
    
    return active_workorder


def post_workorder_attachment(id, attachement_name, job_manager):
#     """
#     Posts an attachment to a particular Job ... .TBD needs to be the active Job??
#     
#     (for MTS/T-BERD family)
# 
#     Args:
#         
#     Returns:
#         
#     """
# 
     job_dir = get_job_dir()

     return False


