"""
Module that contains schemas for the config information of different tests to
launch on the CellAdvisor5G product family
"""
from marshmallow import Schema, fields, validates_schema, ValidationError
from marshmallow.validate import OneOf

from .config_schema_common import ConfigBase, test_type_factory
from rest_api.products import config_schemas_5800 as common
from rest_api.products import config_schemas_caa as caa
from rest_api.products import module_schemas_ca5g as ca5g

#pylint: disable=no-self-use

CONFIG_SCHEMAS = {'Fiber Inspection': common.FiberInspectionSchema,
                  'OTDR': common.OTDRSchema,
                  'opticalPower': common.PowerMeterConfigSchema,
                  'CAA Reflection VSWR': caa.CAAReflectionVSWR,
                  'CAA Reflection Return Loss': caa.CAAReflectionReturnLoss,
                  'CAA DTF VSWR': caa.CAADTFVSWR,
                  'CAA DTF Return Loss': caa.CAADTFReturnLoss,
                  'CAA 1 Port Cable Loss': caa.CAA1PortCableLoss,
                  'CAA 1 Port Phase': caa.CAACAA1PortPhase,
                  'CAA Smith Chart': caa.CAASmithChart,
                  'CAA Check': caa.CAACheckConfigSchema,
                  'RF Sweep Tuned Spectrum': ca5g.RASASweepTunedSpectrum,
                  'RF Channel Power' : ca5g.RASAChannelPower,
                  'RF Occupied Bandwidth' : ca5g.RASAOccupiedBandwidth,
                  'RF Spectrum Emission Mask' : ca5g.RASASpectrumEmissionMask,
                  'RF Adjacent Channel Power' : ca5g.RASAAdjacentChannelPower,
                  'RF Multi Adjacent Channel Power' : ca5g.RASAMultiAdjacentChannelPower,
                  'RF Spurious Emissions' : ca5g.RASASpuriousEmissions,
                  'RF Total Harmonic Distortion' : ca5g.RASATotalHarmonicDistortion,
                  'RF Field Strength' : ca5g.RASAFieldStrength,
                  'RF AM/FM Demodulation' : ca5g.RASAAMFMAudioDemodulation,
                  'RF Gated Sweep' : ca5g.RASAGatedSweep,
                  'RF Route Map' : ca5g.RASARouteMap,
                  'IA Spectrum' : ca5g.RAIASpectrum,
                  'IA Spectrogram' : ca5g.RAIASpectrogram,
                  'IA RSSI' : ca5g.RAIARSSI,
                  'IA Interference Finder' : ca5g.RAIAInterferenceFinder,
                  'IA Radar Chart' : ca5g.RAIARadarChart,
                  'IA PIM Detection Single Carrier' : ca5g.RAIAPIMDetectionSingleCarrier,
                  'IA PIM Detection Multi Carrier' : ca5g.RAIAPIMDetectionMultiCarrier,
                  'RT Persistent Spectrum' : ca5g.RARtSAPersistentSpectrum,
                  'RT Persistent Spectrogram' : ca5g.RARtSAPersistentSpectrogram,
                  'RT Persistent RSSI' : ca5g.RARtSAPersistentRSSI,
                  'RT Persistent Interference Finder' : ca5g.RARtSAPersistentInterferenceFinder,
                  'RT Persistent Radar Chart' : ca5g.RARtSAPersistentRadarChart,
                  'RT Channel Scanner' : ca5g.RAChannelScanner,
                  'RT Frequency Scanner' : ca5g.RAFrequencyScanner,
                  'RT Custom Scanner' : ca5g.RACustomScanner,
                  'LTE TDD Spectrum': ca5g.RALTETDDSpectrum,
                  'LTE TDD Channel Power' : ca5g.RALTETDDChannelPower,
                  'LTE TDD Occupied Bandwidth' : ca5g.RALTETDDOccupiedBandwidth,
                  'LTE TDD Spectrum Emission Mask' : ca5g.RALTETDDSpectrumEmissionMask,
                  'LTE TDD Adjacent Channel Power' : ca5g.RALTETDDAdjacentChannelPower,
                  'LTE TDD Multi Adjacent Channel Power' : ca5g.RALTETDDMultiAdjacentChannelPower,
                  'LTE TDD Spurious Emissions' : ca5g.RALTETDDSpuriousEmissions,
                  'LTE TDD Power vs Time (Frame)' : ca5g.RALTETDDPowerVsTimeFrame,
                  'LTE TDD Power vs Time (Slot)' : ca5g.RALTETDDPowerVsTimeSlot,
                  'LTE TDD Constellation' : ca5g.RALTETDDConstellation,
                  'LTE TDD Data Channel' : ca5g.RALTETDDDataChannel,
                  'LTE TDD Control Channel' : ca5g.RALTETDDControlChannel,
                  'LTE TDD Subframe' : ca5g.RALTETDDSubframe,
                  'LTE TDD Frame' : ca5g.RALTETDDFrame,
                  'LTE TDD Time Alignment Error' : ca5g.RALTETDDTimeAlignmentError,
                  'LTE TDD Data Allocation Map' : ca5g.RALTETDDDataAllocationMap,
                  'LTE TDD Carrier Aggregation' : ca5g.RALTETDDCarrierAggregation,
                  'LTE TDD OTA Channel Scanner' : ca5g.RALTETDDOTAChannelScanner,
                  'LTE TDD OTA ID Scanner' : ca5g.RALTETDDOTAIDScanner,
                  'LTE TDD OTA Multipath Profile' : ca5g.RALTETDDOTAMultipathProfile,
                  'LTE TDD OTA Control Channel' : ca5g.RALTETDDOTAControlChannel,
                  'LTE TDD OTA Datagram' : ca5g.RALTETDDOTADatagram,
                  'LTE TDD OTA Route Map' : ca5g.RALTETDDOTARouteMap,
                  'LTE TDD Freq / Time Error Variation' : ca5g.RALTETDDFreqTimeErrorVariation,
                  'LTE TDD Power Statistics CCDF' : ca5g.RALTETDDPowerStatisticsCCDF,
                  'LTE FDD Spectrum': ca5g.RALTEFDDSpectrum,
                  'LTE FDD Channel Power' : ca5g.RALTEFDDChannelPower,
                  'LTE FDD Occupied Bandwidth' : ca5g.RALTEFDDOccupiedBandwidth,
                  'LTE FDD Spectrum Emission Mask' : ca5g.RALTEFDDSpectrumEmissionMask,
                  'LTE FDD Adjacent Channel Power' : ca5g.RALTEFDDAdjacentChannelPower,
                  'LTE FDD Multi Adjacent Channel Power' : ca5g.RALTEFDDMultiAdjacentChannelPower,
                  'LTE FDD Spurious Emissions' : ca5g.RALTEFDDSpuriousEmissions,
                  'LTE FDD Power vs Time (Frame)' : ca5g.RALTEFDDPowerVsTimeFrame,
                  'LTE FDD Power vs Time (Slot)' : ca5g.RALTEFDDPowerVsTimeSlot,
                  'LTE FDD Constellation' : ca5g.RALTEFDDConstellation,
                  'LTE FDD Data Channel' : ca5g.RALTEFDDDataChannel,
                  'LTE FDD Control Channel' : ca5g.RALTEFDDControlChannel,
                  'LTE FDD Subframe' : ca5g.RALTEFDDSubframe,
                  'LTE FDD Frame' : ca5g.RALTEFDDFrame,
                  'LTE FDD Time Alignment Error' : ca5g.RALTEFDDTimeAlignmentError,
                  'LTE FDD Data Allocation Map' : ca5g.RALTEFDDDataAllocationMap,
                  'LTE FDD Carrier Aggregation' : ca5g.RALTEFDDCarrierAggregation,
                  'LTE FDD OTA Channel Scanner' : ca5g.RALTEFDDOTAChannelScanner,
                  'LTE FDD OTA ID Scanner' : ca5g.RALTEFDDOTAIDScanner,
                  'LTE FDD OTA Multipath Profile' : ca5g.RALTEFDDOTAMultipathProfile,
                  'LTE FDD OTA Control Channel' : ca5g.RALTEFDDOTAControlChannel,
                  'LTE FDD OTA Datagram' : ca5g.RALTEFDDOTADatagram,
                  'LTE FDD OTA Route Map' : ca5g.RALTEFDDOTARouteMap,
                  'LTE FDD Freq / Time Error Variation' : ca5g.RALTEFDDFreqTimeErrorVariation,
                  'LTE FDD Power Statistics CCDF' : ca5g.RALTEFDDPowerStatisticsCCDF,
                  '5G TF Beam Analyzer' : ca5g.RA5GTFBeamAnalyzer,
                  '5G TF Carrier Scanner' : ca5g.RA5GTFCarrierScanner,
                  '5G TF Route Map' : ca5g.RA5GTFRouteMap,
                  '5G NR Trigger Spectrum' : ca5g.RA5GNRTriggerSpectrum,
                  '5G NR Channel Power' : ca5g.RA5GNRChannelPower,
                  '5G NR Occupied Bandwidth' : ca5g.RA5GNROccupiedBandwidth,
                  '5G NR Spectrum Emission Mask' : ca5g.RA5GNRSpectrumEmissionMask,
                  '5G NR Adjacent Channel Power' : ca5g.RA5GNRAdjacentChannelPower,
                  '5G NR Multi Adjacent Channel Power' : ca5g.RA5GNRMultiAdjacentChannelPower,
                  '5G NR Spurious Emissions' : ca5g.RA5GNRSpuriousEmissions,
                  '5G NR Beam Analyzer' : ca5g.RA5GNRBeamAnalyzer,
                  '5G NR Carrier Scanner' : ca5g.RA5GNRCarrierScanner,
                  '5G NR Route Map' : ca5g.RA5GNRRouteMap,
                  '5G NR Beam Availability Index' : ca5g.RA5GNRBeamAvailabilityIndex,
                  '5G NR Freq / Time Error Variation' : ca5g.RA5GNRFreqTimeErrorVariation,
                  '5G NR Constellation' : ca5g.RA5GNRConstellation,
                  '5G NR Power vs Time (Symbol)' : ca5g.RA5GNRPowerVsTimeSymbol,
                  '5G NR Power vs Time (Frame)' : ca5g.RA5GNRPowerVsTimeFrame,
                  'EMF Spectrum' : ca5g.RAEMFSpectrum,
                  'EMF 5G NR Beam Analysis' : ca5g.RAEMF5GNRBeamAnalysis,
                  'DSS Spectrum' : ca5g.RADSSSpectrum,
                  'DSS Channel Power' : ca5g.RADSSChannelPower,
                  'DSS Occupied Bandwidth' : ca5g.RADSSOccupiedBandwidth,
                  'DSS Spectrum Emission Mask' : ca5g.RADSSSpectrumEmissionMask,
                  'DSS Adjacent Channel Power' : ca5g.RADSSAdjacentChannelPower,
                  'DSS Multi Adjacent Channel Power' : ca5g.RADSSMultiAdjacentChannelPower,
                  'DSS Spurious Emissions' : ca5g.RADSSSpuriousEmissions,
                  'DSS Power vs Time (Frame)' : ca5g.RADSSPowerVsTimeFrame,
                  'DSS Power vs Time (Slot)' : ca5g.RADSSPowerVsTimeSlot,
                  'DSS Constellation' : ca5g.RADSSConstellation,
                  'DSS Channel Mapper' : ca5g.RADSSChannelMapper,
                  'DSS Control Channel' : ca5g.RADSSControlChannel,
                  'DSS Subframe' : ca5g.RADSSSubframe,
                  'DSS Frame' : ca5g.RADSSFrame,
                  'DSS Time Alignment Error' : ca5g.RADSSTimeAlignmentError,
                  'DSS OTA Channel Scanner' : ca5g.RADSSOTAChannelScanner,
                  'DSS OTA ID Scanner' : ca5g.RADSSOTAIDScanner,
                  'DSS OTA Multipath Profile' : ca5g.RADSSOTAMultipathProfile,
                  'DSS OTA Control Channel' : ca5g.RADSSOTAControlChannel,
                  'DSS OTA Route Map' : ca5g.RADSSOTARouteMap,
                  'DSS Freq / Time Error Variation' : ca5g.RADSSFreqTimeErrorVariation,
                  '5G TM BS Output Power' : ca5g.RA5GTMBSOutputPower,
                  '5G TM Occupied Bandwidth' : ca5g.RA5GTMOccupiedBandwidth,
                  '5G TM Adjacent Channel Power' : ca5g.RA5GTMAdjacentChannelPower,
                  '5G TM Multi Adjacent Channel Power' : ca5g.RA5GTMMultiAdjacentChannelPower,
                  '5G TM Operating Band Unwanted Emissions' : ca5g.RA5GTMUnwantedEmissions,
                  '5G TM Transmitter Spurious Emissions' : ca5g.RA5GTMTransmitterSpuriousEmissions,
                  '5G TM Transmit ON/OFF Power' : ca5g.RA5GTMTransmitONOFFPower,
                  '5G TM Modulation Quality' : ca5g.RA5GTMModulationQuality,
                  '5G TM MIMO Time Alignment Error' : ca5g.RA5GTMMIMOTimeAlignmentError,
                  '5G TM CA Time Alignment Error' : ca5g.RA5GTMCATimeAlignmentError,
                  'NSA Analyzer' : ca5g.RANSAAnalyzer,
                  'NSA Scanner' : ca5g.RANSAScanner,
                  'NSA Route Map' : ca5g.RANSARouteMap,
                  'RFPM Internal RF Power Meter' : ca5g.RARFInternalPowerMeter,
                  'RFPM External RF Power Meter' : ca5g.RARFExternalPowerMeter,
                  'RFoCPRI Spectrum' : ca5g.RARFoCPRISpectrum,
                  'RFoCPRI Spectrogram' : ca5g.RARFoCPRISpectrogram
                 }

class ConfigSchema(ConfigBase):
    """
    Polymorphic mapping for different ConfigSchemas
    """
    type_schemas = CONFIG_SCHEMAS
