"""Module containing functions for interacting with remote control on the
the advisor platform

See https://gitlab.ds.jdsu.net/instrument-platform/remote-control
"""
import dbus

def get_isu_port():
    """Function to return the port number of the ISU process

    Returns:
        port (dbus.UInt32): the port number of the ISU process
    """
    bus_name = 'com.viavisolutions.platform.RemoteControl'
    object_path = '/com/viavisolutions/platform/RemoteControl'
    bus = dbus.SystemBus()
    remote_object = bus.get_object(bus_name, object_path)
    iface = dbus.Interface(remote_object, bus_name)
    clients = iface.GetClients()
    return clients.get("Fiber-ISU")
