import os
import json
import logging
import traceback
import trace
import datetime

from bottle import Bottle, response, request

from rest_api.api.job_manager.plugin import JobManagerPlugin, SideEffect
#from rest_api.products import process_cdm_job_metro

# TBD... Problem/Confusion with file_sync.py definitions ....
# JOB_FILES = "*.job.json" 
# FILE_TYPE_NAME_JOB_TEMPLATES = "CONFIG.Job Templates" #TBC
# For Fiber, .job.json == a Job, not a template. (although they are very similar - up to now both treated as the same thing).

app = Bottle()

log = logging.getLogger(__name__)


@app.post("/api/workflow/v1/workorders")
def post_workorders():
    """Method to receive workorders from Mobile Tech
    
    will store workorders to disk as individual JSON files
    """

    #tracer = trace.Trace(count=True, trace=False)

    log.debug('## Mobile Tech workflow: post_workorders' )

    try:

        cdm_json = request.body.read()

        product_specific = app.config['rest_api.product_specific']
        #if (tracer.runfunc(product_specific.call_process_mta_workflow, cdm_json) == True):
        if (product_specific.call_process_mta_workflow(cdm_json) == True):
            response_status = 200
        else:
            response_status = 400
        

        
        #log.debug('## Mobile Tech workflow file processed' )
    except:
        log.debug('## Mobile Tech workflow : post_workorders ERROR' )
        print(traceback.format_exc())
        response_status = 400

    #results = tracer.results()
    #results.write_results(coverdir='/tmp/coverdir2')

    response.status = response_status
    if (response_status == 200):
        return {}
    else:
        return {'errorMessage': 'Error'}


    

    #jobs_dir = request.app.config.get("rest-api.jobs_dir")
    #cdm_json = request.body.read()

    #product_specific = app.config['rest_api.product_specific']
    #product_specific.call_process_mta_workflow( cdm_json )#, jobs_dir )
    #log.debug('## Mobile Tech workflow file processed' )

#    process_cdm_job_metro.parse_cdm_job(cdm_json, jobs_dir)


@app.get("/api/workflow/v1/list")
def get_workorder_id_list():
    """Returns a list of the workorders currently stored on the instrument"""
    log.debug('## Mobile Tech workflow: get_workorder_id_list' )

    #tracer = trace.Trace(count=True, trace=False)


    workorder_list = {}
    try:
        #product_specific = app.config['rest_api.product_specific']
        #workorder_list = tracer.runfunc(exec_get_workorder_id_list)
        workorder_list = exec_get_workorder_id_list() #product_specific.call_get_workorder_id_list()
        response_status = 200

    except:
        log.debug('## Mobile Tech workflow: get_workorder_id_list ERROR' )
        print(traceback.format_exc())
        response_status = 400

    #results = tracer.results()
    #results.write_results(coverdir='/tmp/coverdir2')
    
    response.status = response_status
    if (response_status == 200):
        return workorder_list
    else:
        return {}



    #jobs_dir = request.app.config.get("rest-api.jobs_dir")
    #jobs = [
    #    filename
    #    for filename in os.listdir(jobs_dir)
    #    #if (filename.endswith(".json") and not filename.endswith(".job.json")) # No good for Fiber --> requires product_specific. (Fiber jobs are named .job.json)
    #    if (filename.endswith(".job.json")) # requires product_specific. (Fiber jobs are named .job.json)
    #]
    #jobs.append("1")  # Hard code the element id of the only job
    #return {"workOrderIds": jobs}

def exec_get_workorder_id_list():
    """
    Gets the list of all work orders (aka Jobs) on the instrument
    
    Args:
        
    Returns:
        
    """

    workOrderIds_list = []
    workOrderInfo_list = []
    
    try:
        product_specific = app.config['rest_api.product_specific']
        job_dir = product_specific.get_job_dir()


        for filename in os.listdir(job_dir):
            if (filename.endswith(product_specific.get_job_extension())):
                try:
                    full_path = os.path.join(job_dir, filename)
                    with open(full_path) as workflow_file:
                        workflow_json_string = workflow_file.read()

                    cdm_job = json.loads(workflow_json_string)
            
                    for cdm in cdm_job['cdm']:
                        workorder_id = cdm['workflow']['workOrderId']
                        workOrderIds_list.append(workorder_id)

                        workflowId = None
                        try:
                            workflowId = cdm['workflow']['workflowId']
                        except:
                            pass

                        fstats = os.stat(full_path)
                        modified_time = fstats.st_mtime
                        
                        try:
                            if (len(cdm['jobModifiedOn']) > 0):
                                md_iso = cdm['jobModifiedOn']
                            else:
                                md_iso = datetime.datetime.utcfromtimestamp(modified_time).isoformat(timespec='seconds') + "+00:00"
                        except:
                            md_iso = datetime.datetime.utcfromtimestamp(modified_time).isoformat(timespec='seconds') + "+00:00"

                        workOrderInfo = {'workOrderId' : workorder_id, 'modifiedTime' : md_iso}

                        try:
                            if ((workflowId != None) and (workflowId != 0)):
                                workOrderInfo['workflowId'] = workflowId
                        except:
                            pass

                        workOrderInfo_list.append(workOrderInfo)

                except:
                    log.debug('## get_workorder_id_list ERROR: skipped {}'.format(filename))
                    print(traceback.format_exc())

    except:
        print(traceback.format_exc())


    returned_list = {"workOrderIds": workOrderIds_list, "workOrderInfo": workOrderInfo_list}

    return returned_list


@app.get("/api/workflow/v1/templates")
def get_template_list():
    """Returns a list of workorder templates currently stored on the instrument"""
    log.debug('## Mobile Tech workflow: get_template_list' )

    template_list = []
    try:
        #product_specific = app.config['rest_api.product_specific']
        template_list = exec_get_template_list() #product_specific.call_get_template_list()
        response_status = 200
    except:
        log.debug('## Mobile Tech workflow: get_template_list  ERROR' )
        print(traceback.format_exc())
        response_status = 400

    
    response.status = response_status
    if (response_status == 200):
        return {"templates": template_list }
    else:
        return {}

    #jobs_dir = request.app.config.get("rest-api.jobs_dir")
    #filenames = [
    #    #filename for filename in os.listdir(jobs_dir) if filename.endswith(".job.json") # No good for Fiber --> requires product_specific. Fiber templates may need to be named differently (.tpl.json ???)
    #    filename for filename in os.listdir(jobs_dir)
    #    if filename.endswith(".tpl.json") # requires product_specific. Fiber templates may need to be named differently (.tpl.json ???)
    #]
    #job_templates = []
    #for filename in filenames:
    #    with open(os.path.join(jobs_dir, filename)) as workfile:
    #        job_templates.append(json.loads(workfile.read()))
    #return {"templates": job_templates}

def exec_get_template_list():
    """
    Gets the list of all Job templates on the instrument
    
    Args:
        
    Returns:
        
    """

    template_list = []
    
    try:
        product_specific = app.config['rest_api.product_specific']
        job_dir = product_specific.get_job_dir()

        for filename in os.listdir(job_dir):
            if (filename.endswith(product_specific.get_template_extension())):
                try:
                    with open(os.path.join(job_dir, filename)) as template_file:
                        template_list.append(json.loads(template_file.read()))

                except:
                    log.debug('## get_template_list ERROR: skipped {}'.format(filename))
    except:
        print(traceback.format_exc())

    return template_list

#@app.get("/api/workflow/v1/workorder/<id>", apply=JobManagerPlugin())
#def get_workorder(id, job_manager):
@app.get("/api/workflow/v1/workorder/<id>")
def get_workorder(id):
    """Returns the details for a specific workOrder (aka Job)"""
    log.debug('## Mobile Tech workflow: get_workorder' )

    #tracer = trace.Trace(count=True, trace=False)

    try:
        #product_specific = app.config['rest_api.product_specific']
        #workorder = tracer.runfunc(exec_get_workorder, id)
        workorder = exec_get_workorder(id) #product_specific.call_get_workorder(id)

        if (len(workorder) > 0):
            response_status = 200
        else:
            response_status = 404

    except:
        log.debug('## Mobile Tech workflow: get_workorder  ERROR' )
        print(traceback.format_exc())
        response_status = 400

    #results = tracer.results()
    #results.write_results(coverdir='/tmp/coverdir3')


    response.status = response_status
    
    if (response_status == 200):
        return workorder
    else:
        return {}
    

    #if id == "1":
    #    job = job_manager.load_job(1)
    #    return {"cdmVersion": "2.1", "cdm": job.cdm["cdm"][0]}

    #jobs_dir = request.app.config.get("rest-api.jobs_dir")
    #with open(os.path.join(jobs_dir, id)) as workfile:
    #    cdm = json.loads(workfile.read())
    #return {"cdmVersion": "2.1", "cdm": cdm["cdm"][0]}

def exec_get_workorder(workorder_id_param):
    """
    Gets the content of a specific Work Order (aka Job)

    Args:
        
    Returns:
        
    """

    workorder_id_param = workorder_id_param
    workorder = {}

    try:
        product_specific = app.config['rest_api.product_specific']
        job_dir = product_specific.get_job_dir()
    
        for filename in os.listdir(job_dir):
            if (filename.endswith(product_specific.get_job_extension())):
                try:
                    file_path = os.path.join(job_dir, filename)
                    with open(file_path) as workflow_file:
                        workflow_json_string = workflow_file.read()

                    cdm_job = json.loads(workflow_json_string)
            
                    for cdm in cdm_job['cdm']:
                        workorder_id = cdm['workflow']['workOrderId']
                        if (workorder_id == workorder_id_param):
                            fstats = os.stat(file_path)
                            modified_time = fstats.st_mtime
                            md_iso = datetime.datetime.utcfromtimestamp(modified_time).isoformat(timespec='seconds') + "+00:00"

                            workorder = {'cdm' : cdm}

                            try:
                                if (len(workorder['cdm']['jobModifiedOn']) == 0):
                                    workorder['cdm']['jobModifiedOn'] = md_iso
                            except:
                                workorder['cdm']['jobModifiedOn'] = md_iso
                            
                            try:
                                workorder['cdmVersion'] = cdm_job['cdmVersion']
                            except:
                                workorder['cdmVersion'] = '2.1'
                            
                            break

                except:
                    log.debug('## get_workorder ERROR: skipped {}'.format(workorder_id_param))

                if (len(workorder) > 0):
                    break;

    except:
        print(traceback.format_exc())

    return workorder

@app.get("/api/workflow/v1/active", apply=JobManagerPlugin())
def get_active_workorder(job_manager):
    """
    Returns the id of the currently active workorder (aka Job)

    Args:
        
    Returns:
        
    """
    log.debug('## Mobile Tech : get_active_workorder' )

    # Doc says : string representing the ID of the active workorder, or empty string if no workorder is active

    active_workorder_id = ''
    try:
        active_workorder_id = exec_get_active_workorder(job_manager)

        response.status = 200


    except:
        log.debug('## Mobile Tech workflow: get_active_workorder ERROR' )
        #print(traceback.format_exc())
        response.status = 400
        active_workorder_id = ''

    log.debug('get_active_workorder [Returning %s]', active_workorder_id )

    return {"activeWorkOrderId": active_workorder_id}

    #job = job_manager.load_job(1)
    #active_job = "1" if job_manager.active_state else None
    #return {"activeWorkOrderId": active_job}


def exec_get_active_workorder(job_manager):
    """
    Returns the id of the currently active workorder (aka Job)

    Args:
        
    Returns:
        
    """

    # Doc says : string representing the ID of the active workorder, or empty string if no workorder is active

    active_workorder_id = ''
    try:
        job = job_manager.load_job(1)
        if job_manager.active_state:
        
            active_job_number = job.job_number

            try:
                workflow = job.get_cdm_workflow()
                active_workorder_id = workflow['workflow']['workOrderId']
            except:
                active_workorder_id = ''

            if (len(active_workorder_id) == 0):
                log.debug('get_active_workorder : No CDM workOrderId found: job_number %s returned', active_job_number)
                active_workorder_id = active_job_number

            if (active_job_number != active_workorder_id):
                log.debug('get_active_workorder : job_number {0} and CDM workOrderId {1} are different'.format(active_job_number, active_workorder_id))



            # unless I am wrong, this function is not product dependent
            # However the skeleton exists
            # product_specific = app.config['rest_api.product_specific']
            #active_workorder_id = product_specific.call_get_active_workorder() # the skeleton exists



    except:
        log.debug('## Mobile Tech workflow: exec_get_active_workorder ERROR' )
        #print(traceback.format_exc())
        active_workorder_id = ''


    return active_workorder_id




#@app.put("/api/workflow/v1/active", apply=[JobManagerPlugin(), SideEffect()])
#def put_active_workorder(job_manager, side_effect):
@app.put("/api/workflow/v1/active", apply=JobManagerPlugin())
def put_active_workorder(job_manager):
    """Sets a specific workorder to be active"""
    log.debug('## Mobile Tech workflow: put_active_workorder' )

    #tracer = trace.Trace(count=True, trace=False)


    try:
        active_workorder_json = request.json

        #product_specific = app.config['rest_api.product_specific']
        #if (tracer.runfunc(call_put_active_workorder, active_workorder_json) == True):
        if (exec_put_active_workorder(active_workorder_json) == True):
            response.status = 200
        else:
            response.status = 404


    except:
        log.debug('## Mobile Tech workflow: put_active_workorder ERROR' )
        #print(traceback.format_exc())
        response.status = 400


    #results = tracer.results()
    #results.write_results(coverdir='/tmp/coverdir2')


    return get_active_workorder(job_manager)


    #jobs_dir = request.app.config.get("rest-api.jobs_dir")
    #body = request.json

    ## Assume the job file is stored in the job manager directory
    ## and named {work_order_id).json
    ## --> Product _specific needed: Fiber jobs all named .job.json to avoid confusion with all other CDM results json files.
    ##     SHOULD BE USING process_cdm_job here too. 
    ##     Also requires SCPI to ISU in certain circumstances (such as AT&T) if we are not using the standard Job Manager GUI.
    ##
    ## file_path = os.path.join(jobs_dir, "{activeWorkOrderId}.json".format(**body))
    #file_path = os.path.join(jobs_dir, "{activeWorkOrderId}.job.json".format(**body))
    #log.debug('## Mobile Tech : set active Job' )

    #if not os.path.isfile(file_path):
    #    response.status = 422
    #    return {}


# Maybe for Metro, not exactly the same for Fiber... (ATT differences, etc.)
#     job_eid = 1
#     job_manager.load_job(job_eid)
#     job_info = job_manager.load_job_from_file(file_path)
#     job_manager.set_active(job_eid)
#     job_manager.set_active_test_plan_index(job_eid, -1)
#     side_effect(job_info)

#    return body


def exec_put_active_workorder(active_workorder_json_param):
    """
    Sets the active work order (Job) on the instrument
    
    Args:
        
    Returns:
        
    """

    job_set = False
    
    try:
        product_specific = app.config['rest_api.product_specific']
        job_dir = product_specific.get_job_dir()
        #top_schema = product_specific.cdm_schema

        workorder_id_param = active_workorder_json_param['activeWorkOrderId']

        for filename in os.listdir(job_dir):
            if (filename.endswith(product_specific.get_job_extension())):
                try:
                    file_path = os.path.join(job_dir, filename)
                    with open(file_path) as workflow_file:
                        workflow_json_string = workflow_file.read()

                    # For performance reason, we cannot parse all files to look for the worker ID using top_schema (time consuming process)
                    # call_notify_job_received will do it
                    cdm_job = json.loads(workflow_json_string)

                    for cdm_mta in cdm_job['cdm']:
                        workorder_id = cdm_mta['workflow']['workOrderId']
                        if (workorder_id == workorder_id_param):

                            job_set = product_specific.call_notify_job_received(file_path, cdm_mta)
                            log.debug('##--- Activated Job [%s] (status %d) ---##', file_path, job_set)
                            break

                except:
                    log.debug('## exec_put_active_workorder ERROR: skipped {}'.format(filename))

    except:
        print(traceback.format_exc())

    return job_set


@app.post("/api/workflow/v1/workorder/<id>/attachment", apply=JobManagerPlugin())
def post_workorder_attachment(id, job_manager):
    log.debug('## Mobile Tech workflow: post_workorder_attachment' )

    try:
        metadata = request.files.get('metadata')
        metadata_data = json.load(metadata.file)
        
        filename = metadata_data['name']
        fileUri = metadata_data['fileUri']

        # The doc says ' shall have name of "filedata"'
        filedata = request.files.get('filedata')
        filedata.save(fileUri, overwrite=True)

        attachement_name = fileUri


        workorder = get_workorder(id)

        if (len(workorder) > 0): 
            # workerorder exists
            active_workorder = get_active_workorder(job_manager)
            if (active_workorder['activeWorkOrderId'] == id):
                job = job_manager.load_job(1)

                test_data = {
                    'test_type': 'Unknown',
                    'verdict': 'NotApplicable',
                    'file_path': attachement_name,
                    'reference_info': [],
                    'sub_type_info': [],
                }

                job_manager.add_test_data(test_data)

                response_status = 200
            else:
                # 'id' is not the active workorder
                # the documentation doesn't specified a return status for this case
                response_status = 404
        else:
            # workerorder not found
            response_status = 404



        # unless I am wrong, this function is not product dependent
        #product_specific = app.config['rest_api.product_specific']
        #if (product_specific.call_post_workorder_attachment(id, attachement_name, job_manager) == True):
        #    response_status = 200
        #else:
        #    response_status = 404


    except:
        log.debug('## Mobile Tech workflow: post_workorder_attachment ERROR' )
        #print(traceback.format_exc())
        response_status = 400




    response.status = response_status
    if (response_status == 200):
        return {}
    else:
        return {'errorMessage': 'Error'}

