# pylint: skip-file
"""
Module containing functions for V0 of the user files rest api

The API's in this module are deprecated

This module exists to continue supporting functionality with the
T-BERD Companion Mobile app.  That app has been deprecated in favor of
the Mobile Tech app.
"""

import os
try:
    from urllib import quote  # Python 2.X
except ImportError:
    from urllib.parse import quote  # Python 3+

from bottle import request, response, static_file, Bottle


user_files = Bottle() # pylint: disable=C0103


@user_files.get('/api/v0/userfiles')
@user_files.get('/api/v0/userfiles/')
def file_list():
    """Endpoint to list the files and directories of the base directory
    ---
    get:
      deprecated: true
      tags:
        - user files
      description: Endpoint to list the files and directories of the base directory
      responses:
        200:
          description: success
          schema: {'$ref': '#/definitions/UserDirectory'}
    """
    base_dir = request.app.config.get('user_files.base_dir') #pylint: disable=no-member

    return get_dir_json(base_dir, base_dir)


@user_files.get('/api/v0/userfiles/<file_path:path>')
def file_list_subdir(file_path):
    """
    Endpoint to either list the files and directories in the file_path or to
    return the file to the client
    ---
    get:
      deprecated: true
      tags:
        - user files
      description: >
                     Endpoint to either list the files and directories in the
                     file_path or to return the file to the client
      parameters:
        - in: path
          name: file_path
          type: string
      responses:
        200:
          description: success
        400:
          description: file or directory not found
    """
    base_dir = request.app.config.get('user_files.base_dir') #pylint: disable=no-member

    full_path = os.path.join(base_dir, file_path)
    if os.path.isdir(full_path):
        return get_dir_json(full_path, base_dir)
    if os.path.isfile(full_path):
        return static_file(file_path, root=base_dir)

    response.status = 400
    return {}

@user_files.delete('/api/v0/userfiles/<file_path:path>')
def delete_file(file_path):
    """Endpoint for deleting a file from the instrument
    ---
    delete:
      deprecated: true
      tags:
        - user files
      description: Endpoint for deleting a file from the instrument
      parameters:
        - in: path
          name: file_path
          type: string
      responses:
        200:
          description: success
        404:
          description: invalid file path
        500:
          description: could not delete file
    """
    base_dir = request.app.config.get('user_files.base_dir') #pylint: disable=no-member

    full_path = os.path.join(base_dir, file_path)
    if os.path.isfile(full_path):
        os.remove(full_path)
        response.status = 200
    else:
        response.status = 404

@user_files.post('/api/v0/userfiles')
@user_files.post('/api/v0/userfiles/')
def save_file():
    """Endpoint for uploading a file to the instrument
    ---
    post:
      deprecated: true
      tags:
        - user files
      description: Endpoint to upload a file to the instrument
      consumes:
        - multipart/form-data
      parameters:
        - in: formData
          name: upfile
          type: file
          description: The file to upload.
      responses:
        200:
          description: success
    """
    upload_dir = request.app.config.get('user_files.upload_dir') #pylint: disable=no-member

    upload = request.files.get('filedata') #pylint: disable=no-member
    upload.save(upload_dir, overwrite=True)


def get_dir_json(path, base_dir):
    """Function to create a dictionary representing the directory
    the swagger schema is below
    ---
    type:
      enum:
        - D
      type: string
      description: >
                      the type response for this object for directories this
                      will be D
    name:
      type: string
      description: The name of the directory on the file system
    path:
      type: string
      description: the relative path to the directory from the base directory
    files:
        items:
          $ref: '#/definitions/UserFile'
        type: array
        description: list of UseFile objects in this directory
    subdirs:
      items:
        $ref: '#/definitions/UserDirectory'
      type: array
      description: list of UserDirectory for each subdirectory
    """
    res = {'type':'D'}
    dir_name = os.path.basename(os.path.normpath(path))
    dir_path_rel = os.path.relpath(path, base_dir)
    append_base = lambda c: os.path.join(path, c)
    content_paths_abs = map(append_base, os.listdir(path))
    files = filter(os.path.isfile, content_paths_abs)
    dirs = filter(os.path.isdir, content_paths_abs)
    res['name'] = dir_name
    res['path'] = dir_path_rel
    res['files'] = [filepath_to_dict(f, base_dir) for f in files]
    res['subdirs'] = [get_dir_json(d, base_dir) for d in  dirs]
    return res


def filepath_to_dict(filepath, base_dir):
    """Function to create a dictionary representing the file path
    the swagger schema is below
    ---
    type:
      enum:
        - F
      type: string
      description: the type of this object for files this will be F
    name:
      type: string
      description: the name of the file
    path:
      type: string
      description: the relative path to the file from the base directory
    mtime:
      type: string
      description: time of most recent content modification fo rthis file
    size:
      type: string
      description: 'the size of the file, in bytes'
    """
    res = {'type': 'F'}
    fstats = os.stat(filepath)
    file_name = os.path.basename(filepath)
    file_path_rel = os.path.relpath(filepath, base_dir)
    res['name'] = file_name
    res['mtime'] = fstats.st_mtime
    res['size'] = fstats.st_size
    res['path'] = quote(file_path_rel)
    return res
