'''
set of methods to convert cdm json file to a Job object
'''

def load_from_cdm_string(input_json, cdm_schema):
    '''
    Create a Job from a cdm json file
    '''
    try:
        cdm_job = cdm_schema().loads(input_json)
    except ValueError:
        return None

    if cdm_job.errors:
        return None

    workflow = cdm_job.data['cdm'][0]['workflow']


    job = {
        'job_number': workflow['workorder_id'],
        'customer_name': workflow['customer_info']['company'],
        'technician_id': workflow['tech_info']['tech_id'],
        'workflow_id': workflow['workflow_id'],
        'test_location': workflow['workorder_attributes']['testLocation']['value'],
        'logo': workflow['domain_attributes']['logo']
    }

    job['test_plan'] = get_cdm_test_plan(cdm_job)
    
    job['cdm_string'] = input_json

    return job

def get_cdm_test_plan(cdm_job):
    """Convert the `tests` dictionary in cdm format to a `test_plan` format
    """
    test_plan = []
    try:
        tests = cdm_job.data['cdm'][0]['tests']
    except KeyError:
        return test_plan
    for test in tests:
        planned_test = {'test_type': test['type'],
                        'status': test.get('status', 'To Do')}

        refinfolist = []
        if 'attributes' in test.keys():
            attributes = test['attributes']
            for attr_key, attr_dict in attributes.items():
                refinfo = {}
                refinfo['key'] = attr_key
                refinfo['value'] = attr_dict['value']
                refinfolist.append(refinfo)

        planned_test['reference_info'] = refinfolist
        planned_test['procedures'] = test.get('procedures', '')
        planned_test['config'] = test.get('configuration', '')
        planned_test['test_data'] = []
        test_plan.append(planned_test)
    return test_plan
