"""
Module containing helper functions primarily for formating objects for rendering
in html
"""

def html_format_test_data(test_data):
    '''
    Helper function to format a single dictionary of test data into a format
    that is easier for the template to consume

    Args:
        test_data (dict): dictionary of the test data

    Returns:
        test_data (dict): the formatted test data
    '''
    reference_info_str_list = ['<b>{}</b>: {}'.format(reference_info['key'],
                                                      reference_info['value'])
                               for reference_info
                               in test_data['reference_info']]
    return_data = {
        'verdict': get_formated_verdict(test_data),
        'test_type': test_data['test_type'],
        'filename': get_file_name(test_data['file_path']),
        'reference_info_str_list': reference_info_str_list
    }
    if 'comments' in test_data:
        return_data['comments'] = test_data['comments']
    return return_data

def get_formated_verdict(test_data):
    """
    Function to format the verdict report redable format

    Agrs:
        test_data (dict): the test data dict
    """
    if test_data['verdict'] == "NotApplicable":
        verdict = 'N/A'
    elif test_data['verdict'] == 'Pass':
        verdict = '<span class="pass">Pass</span>'
    elif test_data['verdict'] == 'Fail':
        verdict = '<span class="fail">Fail</span>'
    elif test_data['verdict'] == 'Marginal':
        verdict = '<span class="marginal">Marginal</span>'
    else:
        verdict = test_data['verdict']
    return verdict

def get_formated_status(status):
    """
    Function to format the planned test status into a format
    that is able to be processed by the template

    Args:
        status (str): the status of the planned test
    """
    if status == 'Pass':
        formated_status = '<span class="pass">Pass</span>'
    elif status == 'Fail':
        formated_status = '<span class="fail">Fail</span>'
    elif status == 'Marginal':
        formated_status = '<span class="marginal">Marginal</span>'
    else:
        formated_status = status

    return formated_status

def get_file_name(file_path):
    """
    Function to return the file name from the file path

    Args:
        file_path (str): the filepath for the test_data
    """
    return file_path.rsplit('/', 1)[-1]
