from smbus import SMBus




class PCA9535:

    INPUT_PORT_0  = 0
    INPUT_PORT_1  = 1
    OUTPUT_PORT_0  = 2
    OUTPUT_PORT_1  = 3
    POLARITY_PORT_0  = 4
    POLARITY_PORT_1  = 5
    CONFIG_PORT_0  = 6
    CONFIG_PORT_1  = 7

    def retry_read(self, adress):
        val1 = self._i2c.read_byte_data(self._pca_adress,adress)
        val2 = self._i2c.read_byte_data(self._pca_adress,adress)
        for retry in range(0,10):
            val3 = self._i2c.read_byte_data(self._pca_adress,adress)
            if( (val1==val2) and (val2==val3)):
                break
            else:
                val1=val2
                val2=val3
        return val1

    def __init__(self, i2c_no, pca_adress):
        self._i2c = SMBus(i2c_no)
        self._pca_adress = pca_adress

    def configure_port(self, port, config):
        self._i2c.write_byte_data(self._pca_adress,port+self.CONFIG_PORT_0,config)

    def setPortOut(self, port, io_no, val):
        old_val = self.retry_read(port+self.OUTPUT_PORT_0)
        new_out = (old_val & ~( 1 << io_no)) | ( val << io_no)
        self._i2c.write_byte_data(self._pca_adress,port+self.OUTPUT_PORT_0,new_out)

    def getPortOut(self, port, io_no):
        val = self._i2c.retry_read(port+self.OUTPUT_PORT_0)
        return (( 1 << io_no) & val) >> io_no

    def readPortIn(self, port, io_no):
        val = self.retry_read(port+self.INPUT_PORT_0)
        return (( 1 << io_no) & val) >> io_no
