import QtQuick 2.3
import "Viavi_Colors.js" as VColor

Item {
    id: setupSubLine

    width: 250
    height: 60

    property alias inputText: sublineName.text
    property alias outputValue: txtValue.text
    
    property bool enableSelection: true
    
    property int margin: 4

    property int width_img: 20
    property int height_img: 20
    property string path_img: "/acterna/storage/look-and-feel/generic/Icon_Settings.png"
    
    property bool headerVisible: false
    
    // Signals
    signal openEditorClicked();
    
    enabled: enableSelection   
    

    Rectangle {
        id: headerContainer
        color: VColor.cViaviColorGray
        height: parent.height
        width: parent.width / 2 - margin / 2
        visible: headerVisible

        opacity: enableSelection ? 1 : 0.7

        Text {
            id: sublineName
            anchors.fill: parent
            anchors.margins: margin / 2
            color: VColor.cViaviColorWhite
            text: "N/A"
            font.pixelSize: 18
            clip: true
            wrapMode: Text.Wrap
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
        }
    }

    Rectangle {
        id: boxValue
        height: parent.height - 1
        width: headerVisible ? (parent.width / 2 - margin / 2) : (parent.width - margin)

        opacity: enableSelection ? 1 : 0.7

        anchors.left: headerVisible ? (headerContainer.right) : parent.left
        anchors.leftMargin: headerVisible ? margin : margin / 2
        anchors.right: parent.right

        border.width: 1
        border.color: VColor.cViaviColorLogoPurple
        color: VColor.cViaviColorWhite

        TextInput {
            id: txtValue
            anchors.centerIn: parent
            cursorVisible: false
            text: "00.000"
            font.pixelSize: 16
            maximumLength: 20
        }
        Image {
            width: width_img - 2
            height: height_img - 2
            anchors.right: parent.right
            anchors.rightMargin: 2
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 2
            source: path_img
            fillMode: Image.PreserveAspectFit
            visible: enabled
            
            cache: false
			asynchronous: true
        }
    }
    
    MouseArea {
	    anchors.fill: parent
	    onClicked: {
	        openEditorClicked();
	    }
    }
}
