import QtQuick 2.3
import "Viavi_Colors.js" as VColor

Rectangle {
    id: ibtn

    property string shiftText: "\u23CF" //"\u21E7"
    //property string capslockText: "\u21EA"

    property int key : Qt.Key_unknown
    property bool withRepeat: false
    property string textSend: ""
    property string textDisplay: ""
    property bool isEnabled: true
    property string buttonReleaseColor: VColor.cViaviColorWhite
    property string buttonPressColor: VColor.cViaviColorLightBlue // to match other keyboards & Job Manager
    property int txtSize: 25
    property string pathIcon: ""

    property alias actionClick: clickArea
    property int buttonHeight: 56

    color: buttonReleaseColor
    width: 60
    height: buttonHeight
    radius: 5
    opacity: isEnabled ? 1 : 0.3
    
    property int iconSize: width-20

    Text {
        id: txtButton
        text: textDisplay
        font.pixelSize: txtSize
        visible: pathIcon == ""

        color: VColor.cViaviRealBlack
        // Use different anchor topMargin if button pressed to move text upwards (=> not hidden under fingertip)
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter
        clip: true
    }

	Image {
		id: infoIcon
		visible: pathIcon != ""
		source: pathIcon
		fillMode: Image.PreserveAspectFit
		smooth: true
		
		anchors.centerIn: parent
		width: iconSize
		height: iconSize
	}

    MouseArea {
        id: clickArea
        anchors.fill: parent
        enabled: isEnabled
        onClicked: {
            textSend == "" ? addText(textDisplay) : addText(textSend)
        }

        onPressed: {
            ibtn.color = buttonPressColor;
            txtButton.anchors.verticalCenter = undefined;
            txtButton.anchors.bottom = parent.verticalCenter;
            //txtButton.anchors.baseline = parent.verticalCenter;
            
            }
        onReleased: {
            txtButton.anchors.bottom = undefined;
            //txtButton.anchors.baseline = undefined;
            txtButton.anchors.verticalCenter = parent.verticalCenter;
            
            if (txtButton.text == shiftText)// || txtButton.text == capslockText) 
               {
               upperKeyPressed = !upperKeyPressed
               
               buttonReleaseColor = upperKeyPressed ? VColor.cViaviColorLightBlue : VColor.cViaviColorWhite
               }

            ibtn.color = buttonReleaseColor;
            }
    }
}
