<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\monitoring\cache;

use app\util\SMTUtil;

/**
 * Test data cache to keep for the given operation Id during measure
 * 
 * @author Sylvain Desplat
 *
 */
class SMTTestDataDto extends SMTOperationDataDto
{          
    /**
     * Test identifier 
     * @var number
     */    
    protected $testId;
       
    /**
     * @var string OTDR trace name to download
     */
    protected $traceName;
        
    /**
     * @var string OTU directory where OTDR trace is located
     */
    protected $traceDirectory;    
       
    
    function getTestId()
    {
    	return $this->testId;
    }
    
    function setTestId( $testId )
    {
    	$this->testId = SMTUtil::convertToInt( $testId );
    }    
    
    function getTraceDirectory()
    {
    	return $this->traceDirectory;
    }
    
    function setTraceDirectory( $traceDirectory )
    {
    	$this->traceDirectory = $traceDirectory;
    }    
    
    function getTraceName()
    {
    	return $this->traceName;
    }
    
    function setTraceName( $traceName )
    {
    	$this->traceName = $traceName;
    }            
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }            
    
    /**
     * Returns the dto class name.
     *
     * @return the dto class name.
     */
    public static function getClass()
    {
    	return __CLASS__;
    }    

    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return \app\services\monitoring\SMTLinkTestDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }    
}

?>