<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\serviceshelper\maintenance;

/**
 * Isu licenses.
 * 
 * @author Sylvain Desplat
 */
final class SMTLicenseList
{
	
	const SSH_KEY_ACCESS= 'SSH_KEY_ACCESS';
	const ENHANCEDSECURITY = 'ENHANCEDSECURITY';
	const PEAK_MON= 'PEAK_MON';
	const DUAL_OS= 'DUAL_OS';
	const EXT_TEMP_RANGE= 'EXT_TEMP_RANGE';
	const PON_TEST= 'OTU_PON';
	const SAA= 'SMART_ACCESS_ANYWHERE';
	const TAPPING_MON= 'OTU_TAPPING';
	const LIGHT_SOURCE= 'LIGHT_SOURCE';
	const REST_API= 'REST_API';
	const ULTRAFAST_MON='ULTRAFAST_MON';
	const OTU_VPN='OTU_VPN';
	const OTU_PAYG_PORT12='PAYG_PORT012';
	const OTU_ONMSI_MONITORING='ONMSI_MONITORING';
	const OTU_ONMSI_BUILD='ONMSI_BUILD';
	
	const OTU_OPTION_HIGH_SEC = 'HIGHSEC';
	const OTU_OPTION_SSH_KEY_ACCESS = 'ACCESS';
	const OTU_OPTION_PEAK_MONITORING = 'PEAK';
	const OTU_OPTION_DUAL_OS_MONITORING = 'DUAL_OS';
	const OTU_OPTION_EXT_TEMP_RANGE_MONITORING = 'EXT_TEMP_RANGE';
	const OTU_OPTION_TEST_PON_MONITORING = 'TEST_PON';
	const OTU_OPTION_SAA_L2_MONITORING = 'SAA_L2';
	const OTU_OPTION_TAPPING_MONITORING = 'TAPPING';
	const OTU_OPTION_LIGHT_SOURCE= 'LIGHT_SOURCE';
	const OTU_OPTION_REST_API= 'REST_API';
    const OTU_OPTION_ULTRAFAST_MON='ULTRAFAST_MON';
    const OTU_OPTION_VPN='OTU_VPN';
    const OTU_OPTION_PAYG_PORT12='PAYG_PORT012';
    const OTU_OPTION_ONMSI_MONITORING='ONMSI_MON';
    const OTU_OPTION_ONMSI_BUILD='ONMSI_BUILD';
    
	const ISU_OPTION_SAA_L2_MONITORING = 'SMART_ACCESS_L2';
	
// NOT VALID IN PHP 5.4 (OTU8Kv2)	
// 	const OTU_OPTIONS = array(self::OTU_OPTION_HIGH_SEC=>self::SSH_KEY_ACCESS,
// 							  self::OTU_OPTION_SSH_KEY_ACCESS=>self::ENHANCEDSECURITY,
// 			                  self::OTU_OPTION_PEAK_MONITORING=>self::PEAK_MON,
// 							  self::OTU_OPTION_DUAL_OS_MONITORING=>self::DUAL_OS,
// 							  self::OTU_OPTION_EXT_TEMP_RANGE_MONITORING=>self::EXT_TEMP_RANGE,
// 							  self::OTU_OPTION_TEST_PON_MONITORING=>self::PON_TEST,
// 							  self::OTU_OPTION_SAA_L2_MONITORING=>self::SAA);

	private static $OTU_OPTIONS = array(self::OTU_OPTION_HIGH_SEC=>self::ENHANCEDSECURITY,
										self::OTU_OPTION_SSH_KEY_ACCESS=>self::SSH_KEY_ACCESS,
										self::OTU_OPTION_PEAK_MONITORING=>self::PEAK_MON,
										self::OTU_OPTION_DUAL_OS_MONITORING=>self::DUAL_OS,
										self::OTU_OPTION_EXT_TEMP_RANGE_MONITORING=>self::EXT_TEMP_RANGE,
										self::OTU_OPTION_TEST_PON_MONITORING=>self::PON_TEST,
										self::OTU_OPTION_SAA_L2_MONITORING=>self::SAA,
			                            self::OTU_OPTION_TAPPING_MONITORING=>self::TAPPING_MON,
										self::OTU_OPTION_LIGHT_SOURCE=>self::LIGHT_SOURCE,
										self::OTU_OPTION_REST_API=>self::REST_API,
	                                    self::OTU_OPTION_ULTRAFAST_MON=>self::ULTRAFAST_MON,
	                                    self::OTU_OPTION_VPN=>self::OTU_VPN,
	                                    self::OTU_OPTION_PAYG_PORT12=>self::OTU_PAYG_PORT12,
	                                    self::OTU_OPTION_ONMSI_MONITORING=>self::OTU_ONMSI_MONITORING,
	                                    self::OTU_OPTION_ONMSI_BUILD=>self::OTU_ONMSI_BUILD
	);
	
	static function getLicenseName( $scpiKey )
	{
		return self::$OTU_OPTIONS[$scpiKey];
	}
	
	static function getOtuOptionList()
	{
		return self::$OTU_OPTIONS;
	}
}
?>