<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\alarm;

/**
 * Alarms Specific problem codes and texts
 * 
 * @author Sylvain Desplat
 */
class SMTAlarmSpecificProblemCode
{       
    
    /**
     * Optical alarm SPECIFIC PROBLEM CODES
     * 
     */
    const OTU_OPT_ALARM_UNKNOW_ALARM_CODE="UNKNOWN";//-1;
    const OTU_OPT_ALARM_BACK_TO_NORMAL_STATE_CODE="BACK_TO_NORMAL";//10;//cOtu_Alarm_Retour_Normale
//     const OTU_OPT_ALARM_END_OF_SURVEY_CODE="END_OF_SURVEY";//11;
     //specific problem PERSISTENT is NO LONGER USED AND REPLACED BY PERSISTENCE !
    const OTU_OPT_ALARM_PERSISTENT_FAILURE_CODE="PERSISTENT";//12; 
    const OTU_OPT_ALARM_PERSISTENCE_FAILURE_CODE="PERSISTENCE";//12;   
    const OTU_OPT_ALARM_INJECTION_FAILURE_CODE="INJECTION";//1010; //cOtu_Alarm_Injection
    const OTU_OPT_ALARM_REFLECTIVE_FAILURE_CODE="REFLECTIVE";//1020;
    const OTU_OPT_ALARM_SPLICE_FAILURE_CODE="SPLICE";//1030;
    const OTU_OPT_ALARM_LINK_BREAK_CODE="BREAK";//1040;
    const OTU_OPT_ALARM_PON_FAILURE_CODE="PON";//1050;
    const OTU_OPT_ALARM_UNKNOWN_CAUSE_CODE="UNKNOWN";//1060;
    const OTU_OPT_ALARM_TEMPORARY_PROBLEM_CODE="TEMPORARY";//1070;
    const OTU_OPT_ALARM_NON_REFLECTIVE_FAILURE_CODE="NON_REFLECTIVE";//1080;
    const OTU_OPT_ALARM_THRESHOLD_LEVEL_EXCEEDED_CODE="LEVEL";//1090;
    const OTU_OPT_ALARM_CONNECTOR_CODE="CONNECTOR";//1095;
    const OTU_OPT_ALARM_SPLICE_BREAK =                 "SPLICE_BREAK";
    const OTU_OPT_ALARM_CONNECTOR_BREAK =              "CONNECTOR_BREAK";
    const OTU_OPT_ALARM_ATTENUATION_FIBER_BREAK =      "FIBER_BREAK";
    const OTU_OPT_ALARM_SPLICE_ATTENUATION =           "SPLICE_ATTENUATION";
    const OTU_OPT_ALARM_CONNECTOR_ATTENUATION =        "CONNECTOR_ATTENUATION";
    const OTU_OPT_ALARM_FIBER_ATTENUATION =            "FIBER_ATTENUATION";
    const OTU_OPT_ALARM_RAMAN_POWER_DETECTION_CODE="RAMAN_DETECTED_POWER";//1100;
    const OTU_OPT_ALARM_RAMAN_POWER_DECREASE_CODE="RAMAN_LOW_POWER";//1110;
    const OTU_OPT_ALARM_INCOHERENCE_PROBLEM_WITH_RAMAN_ACQUISITION_MODE_CODE="RAMAN_INCOHERENCE";//1120;    
    const OTU_OPT_ALARM_NO_PROBLEM_DETECTED_CODE="NO_PROBLEM_DETECTED";//1130; //cOtu_Alarm_Aucune_Anomalie_Detectee
    
    const OTU_OPT_ALARM_PEAK_CODE="PEAK";
    
    
    const OTU_OPT_ALARM_OTU_ALARM_CONFIRMEE_CODE=1200; //cOtu_Alarm_Confirmee
    const OTU_OPT_ALARM_OTU_ALARM_NON_CONFIRMEE_CODE=1210; //cOtu_Alarm_Non_Confirmee
    
    /**
     * Test whether the alarm code describe an optical alarm problem (not a persistence of failure, not a no problem detected...)  
     * 
     * @param string $alarmCode
     * @return boolean
     */
    static function isOpticalAlarmSpecificProblemCode( $alarmCode )
    {
        return $alarmCode != self::OTU_OPT_ALARM_UNKNOW_ALARM_CODE && 
        $alarmCode != self::OTU_OPT_ALARM_UNKNOWN_CAUSE_CODE &&
        $alarmCode != self::OTU_OPT_ALARM_TEMPORARY_PROBLEM_CODE &&
        $alarmCode != self::OTU_OPT_ALARM_PERSISTENT_FAILURE_CODE &&
        $alarmCode != self::OTU_OPT_ALARM_PERSISTENCE_FAILURE_CODE &&        
        $alarmCode != self::OTU_OPT_ALARM_NO_PROBLEM_DETECTED_CODE &&
        $alarmCode != self::OTU_OPT_ALARM_OTU_ALARM_CONFIRMEE_CODE &&
        $alarmCode != self::OTU_OPT_ALARM_OTU_ALARM_NON_CONFIRMEE_CODE;
    }
    
/**
 * Optical alarm SPECIFIC PROBLEM CODES TEXTS 
 * @var array
 */    
private static $OPTICAL_ALARM_SPECIFIC_PROBLEM_TEXT = 
array( self::OTU_OPT_ALARM_UNKNOW_ALARM_CODE=>UNKNOW_ALARM,
       self::OTU_OPT_ALARM_BACK_TO_NORMAL_STATE_CODE=>BACK_TO_NORMAL_STATE,//cOtu_Alarm_Retour_Normale
//        self::OTU_OPT_ALARM_END_OF_SURVEY_CODE=>END_OF_SURVEY,//cOtu_Alarm_Fin_Suivi
       self::OTU_OPT_ALARM_PERSISTENT_FAILURE_CODE=>PERSISTENT_FAILURE,//
        self::OTU_OPT_ALARM_PERSISTENCE_FAILURE_CODE=>PERSISTENT_FAILURE,//
       self::OTU_OPT_ALARM_INJECTION_FAILURE_CODE=>INJECTION_FAILURE, //cOtu_Alarm_Injection
       self::OTU_OPT_ALARM_REFLECTIVE_FAILURE_CODE=>REFLECTIVE_FAILURE,
       self::OTU_OPT_ALARM_SPLICE_FAILURE_CODE=>SPLICE_FAILURE,
       self::OTU_OPT_ALARM_LINK_BREAK_CODE=>LINK_BREAK,
       self::OTU_OPT_ALARM_PON_FAILURE_CODE=>PON_FAILURE,
       self::OTU_OPT_ALARM_UNKNOWN_CAUSE_CODE=>UNKNOWN_CAUSE,
       self::OTU_OPT_ALARM_TEMPORARY_PROBLEM_CODE=>TEMPORARY_PROBLEM,
       self::OTU_OPT_ALARM_NON_REFLECTIVE_FAILURE_CODE=>NON_REFLECTIVE_FAILURE,
       self::OTU_OPT_ALARM_THRESHOLD_LEVEL_EXCEEDED_CODE=>THRESHOLD_LEVEL_EXCEEDED,
       self::OTU_OPT_ALARM_CONNECTOR_CODE=>CONNECTOR_FAILURE,
       self::OTU_OPT_ALARM_SPLICE_BREAK=>SPLICE_BREAK,
       self::OTU_OPT_ALARM_CONNECTOR_BREAK=>CONNECTOR_BREAK,
       self::OTU_OPT_ALARM_ATTENUATION_FIBER_BREAK=>FIBER_BREAK,
       self::OTU_OPT_ALARM_SPLICE_ATTENUATION=>SPLICE_ATTENUATION,
       self::OTU_OPT_ALARM_CONNECTOR_ATTENUATION=>CONNECTOR_ATTENUATION,
       self::OTU_OPT_ALARM_FIBER_ATTENUATION=>FIBER_ATTENUATION,
       self::OTU_OPT_ALARM_RAMAN_POWER_DETECTION_CODE=>RAMAN_POWER_DETECTION,
       self::OTU_OPT_ALARM_RAMAN_POWER_DECREASE_CODE=>RAMAN_POWER_DECREASE,
       self::OTU_OPT_ALARM_INCOHERENCE_PROBLEM_WITH_RAMAN_ACQUISITION_MODE_CODE=>INCOHERENCE_PROBLEM_WITH_RAMAN_ACQUISITION_MODE,
       self::OTU_OPT_ALARM_NO_PROBLEM_DETECTED_CODE=>NO_PROBLEM_DETECTED, //cOtu_Alarm_Aucune_Anomalie_Detectee
	   
	   self::OTU_OPT_ALARM_PEAK_CODE=>PEAK, // PEAK ALARM
	   
       self::OTU_OPT_ALARM_OTU_ALARM_CONFIRMEE_CODE=>OTU_ALARM_CONFIRMEE, //cOtu_Alarm_Confirmee
       self::OTU_OPT_ALARM_OTU_ALARM_NON_CONFIRMEE_CODE=>OTU_ALARM_NON_CONFIRMEE //cOtu_Alarm_Non_Confirmee
     );


/**
 * SYSTEM ALARM SPECIFIC PROBLEM CODES
 */
const OTU_SYST_ALARM_UNKNOW_ALARM_CODE="UNKNOWN";//-1;
const OTU_SYST_ALARM_MISSING_OR_CORRUPTED_FILE_CODE = "MISSING_OR_CORRUPTED_FILE"; //0; //cOtu_Alarm_File_System
const OTU_SYST_ALARM_LOCAL_MODE_CODE = "LOCAL_MODE"; //1
const OTU_SYST_ALARM_INNER_APPLICATION_COMMUNICATION_PROBLEM_CODE = "INNER_APPLICATION_COMMUNICATION_PROBLEM";
const OTU_SYST_ALARM_REBOOT_CODE = "REBOOT";
const OTU_SYST_ALARM_HARDDISK_SPACE_CODE = "HARDDISK_SPACE";
const OTU_SYST_ALARM_TEMPERATURE_CODE = "TEMPERATURE";
const OTU_SYST_ALARM_SWITCH_PROBLEM_CODE = "SWITCH_PROBLEM";
const OTU_SYST_ALARM_MODULE_PROBLEM_CODE = "MODULE_PROBLEM";
const OTU_SYST_ALARM_MODULE_COMPATIBILITY_CODE = "MODULE_COMPATIBILITY";
const OTU_SYST_ALARM_SWITCH_COMPATIBILITY_CODE = "SWITCH_COMPATIBILITY";
const OTU_SYST_ALARM_LINKS_BACK_TO_AVAILABLE_CODE = "LINKS_BACK_TO_AVAILABLE";
const OTU_SYST_ALARM_MISSING_REFERENCE_TRACE_CODE = "MISSING_REFERENCE_TRACE";
const OTU_SYST_ALARM_SUCCESSFUL_CALLBACK_CODE = "SUCCESSFUL_CALLBACK";
const OTU_SYST_ALARM_TEST_DRIFT_CODE = "TEST_DRIFT";
const OTU_SYST_ALARM_COMMUNICATION_TEST_CODE = "COMMUNICATION_TEST";
const OTU_SYST_ALARM_HEARTBEAT_CODE = "HEARTBEAT";
const OTU_SYST_ALARM_HARDWARE_PROBLEM_CODE = "HARDWARE_PROBLEM";
const OTU_SYST_ALARM_SOFTWARE_PROBLEM_CODE = "SOFTWARE_PROBLEM";
const OTU_SYST_ALARM_MEASUREMENT_CYCLE_CODE = "MEASUREMENT_CYCLE";
const OTU_SYST_ALARM_ALARM_OVERFLOW_CODE = "ALARM_OVERFLOW";
const OTU_SYST_ALARM_GENERIC_ALARM_CODE = "GENERIC_ALARM";
const OTU_SYST_ALARM_REBUILD_CLEAR_CODE = "REBUILD_CLEAR";
const OTU_SYST_ALARM_HDD_FAILED_CODE    = "HDD_FAILED";
const OTU_SYST_ALARM_HDD_FAILED_USE_BACKUP_CODE    = "HDD_FAILED_USE_BACKUP"; //24
const OTU_SYST_ALARM_POWER_FAILURE_CODE    = "POWER_FAILURE"; //25
const OTU_SYST_REFERENCE_DRIFT_FAILURE_CODE    = "REFERENCE_DRIFT"; //26

/**
 * System alarm SPECIFIC PROBLEM CODES TEXTS
 * @var array
 */
private static $SYSTEM_ALARM_SPECIFIC_PROBLEM_TEXT =
array(  self::OTU_SYST_ALARM_UNKNOW_ALARM_CODE=>UNKNOW_ALARM, //-1  //cOtu_Alarm_Unknown_Alarm_Label
        self::OTU_SYST_ALARM_MISSING_OR_CORRUPTED_FILE_CODE=>SYSTEM_FILE, //0   //cOtu_Alarm_File_System
        self::OTU_SYST_ALARM_LOCAL_MODE_CODE=>LOCAL_MODE,
        self::OTU_SYST_ALARM_INNER_APPLICATION_COMMUNICATION_PROBLEM_CODE=>INNER_APPLICATION_COMMUNICATION_PROBLEM,
        self::OTU_SYST_ALARM_REBOOT_CODE=>REBOOT,
        self::OTU_SYST_ALARM_HARDDISK_SPACE_CODE=>HARD_DISK_FREE_SPACE,
        self::OTU_SYST_ALARM_TEMPERATURE_CODE=>MODULE_TEMPERATURE,
        self::OTU_SYST_ALARM_SWITCH_PROBLEM_CODE=>ALARM_SWITCH,
        self::OTU_SYST_ALARM_MODULE_PROBLEM_CODE=>ALARM_MODULE,
        self::OTU_SYST_ALARM_MODULE_COMPATIBILITY_CODE=>MODULE_AUTOCONFIGURATION,
        self::OTU_SYST_ALARM_SWITCH_COMPATIBILITY_CODE=>SWITCH_AUTOCONFIGURATION,
        self::OTU_SYST_ALARM_LINKS_BACK_TO_AVAILABLE_CODE=>LINKS_BACK_TO_AVAILABLE,//10
        self::OTU_SYST_ALARM_MISSING_REFERENCE_TRACE_CODE=>MISSING_REFERENCE_FILE,
        self::OTU_SYST_ALARM_SUCCESSFUL_CALLBACK_CODE=>AUTOTEST_TEST,
        //self::=>ALARM_LIBRE, //NOT USED
        self::OTU_SYST_ALARM_TEST_DRIFT_CODE=>MONITORING_TEST_DRIFT,
        self::OTU_SYST_ALARM_COMMUNICATION_TEST_CODE=>TEST_MEDIA,
        self::OTU_SYST_ALARM_HEARTBEAT_CODE=>HEART_BEAT_SENT_TO_ONMS,
        self::OTU_SYST_ALARM_HARDWARE_PROBLEM_CODE=>INITIALISATION_FAILURE_DUE_TO_HARDWARE,
        self::OTU_SYST_ALARM_SOFTWARE_PROBLEM_CODE=>INITIALISATION_FAILURE_DUE_TO_SOFTWARE,
        self::OTU_SYST_ALARM_MEASUREMENT_CYCLE_CODE=>OTU_ALARM_SEQ_STOPPED,
        self::OTU_SYST_ALARM_ALARM_OVERFLOW_CODE=>OTU_ALARM_OVERFLOW,//20
        self::OTU_SYST_ALARM_GENERIC_ALARM_CODE=>OTU_ALARM_GENERIC_MESSAGE, 
        self::OTU_SYST_ALARM_REBUILD_CLEAR_CODE=>OTU_ALARM_REBUID_CLEAR,
        self::OTU_SYST_ALARM_HDD_FAILED_CODE=>OTU_ALARM_HDD_FAILED,
        self::OTU_SYST_ALARM_HDD_FAILED_USE_BACKUP_CODE=>OTU_ALARM_HDD_FAILED_USE_BACKUP, //24
		self::OTU_SYST_ALARM_POWER_FAILURE_CODE=>OTU_SYST_ALARM_POWER_FAILURE,
		self::OTU_SYST_REFERENCE_DRIFT_FAILURE_CODE=>OTU_SYST_REFERENCE_DRIFT_FAILURE
        
    ); //tOtu_Alarm_Label

/**
 * @param integer $specificProblemCode
 * @param boolean $isCleared
 * 
 * @return string
 */
public static function decodeOpticalAlarmSpecificProblem( $specificProblemCode, $isCleared, $severity )
{
    if ( $isCleared && $specificProblemCode != self::OTU_OPT_ALARM_BACK_TO_NORMAL_STATE_CODE )
    {
        $specificProblemText = BACK_TO_NORMAL_STATE;
    }
    //case of invalid alarm attenuation specific problem ( localization failed, for exemple due to missing reference... )
    else if ( !$isCleared && $specificProblemCode === self::OTU_OPT_ALARM_BACK_TO_NORMAL_STATE_CODE )
    {
        $specificProblemText = self::$OPTICAL_ALARM_SPECIFIC_PROBLEM_TEXT[self::OTU_OPT_ALARM_UNKNOW_ALARM_CODE];
    }
    else if ( $specificProblemCode === self::OTU_OPT_ALARM_CONNECTOR_CODE )
    {
		$specificProblemText = CONNECTOR_FAILURE;
    }
    else
    {
        $specificProblemText= ( self::$OPTICAL_ALARM_SPECIFIC_PROBLEM_TEXT[$specificProblemCode] != NULL )? self::$OPTICAL_ALARM_SPECIFIC_PROBLEM_TEXT[$specificProblemCode]:self::$OPTICAL_ALARM_SPECIFIC_PROBLEM_TEXT[self::OTU_OPT_ALARM_UNKNOW_ALARM_CODE];
    }
    return $specificProblemText;
}

/**
 * Whether the optical alarm has a fault with a valid position
 * 
 * @param String $specificProblemCode
 * 
 * @return boolean
 */
public static function hasSpecificProblemWithDistance( $specificProblemCode )
{
    return $specificProblemCode == self::OTU_OPT_ALARM_REFLECTIVE_FAILURE_CODE || $specificProblemCode == self::OTU_OPT_ALARM_SPLICE_FAILURE_CODE || $specificProblemCode == self::OTU_OPT_ALARM_LINK_BREAK_CODE || $specificProblemCode == self::OTU_OPT_ALARM_THRESHOLD_LEVEL_EXCEEDED_CODE || $specificProblemCode == self::OTU_OPT_ALARM_NON_REFLECTIVE_FAILURE_CODE || $specificProblemCode == self::OTU_OPT_ALARM_CONNECTOR_CODE;
}

/**
 * @param integer $specificProblemCode
 * @param boolean $isCleared
 * 
 * @return string
 */
public static function decodeSystemAlarmSpecificProblem( $specificProblemCode, $isCleared )
{
    $specificProblemText = $isCleared? BACK_TO_NORMAL_STATE.": " : "";
    $specificProblemText.= ( self::$SYSTEM_ALARM_SPECIFIC_PROBLEM_TEXT[$specificProblemCode] != NULL )? self::$SYSTEM_ALARM_SPECIFIC_PROBLEM_TEXT[$specificProblemCode]:self::$SYSTEM_ALARM_SPECIFIC_PROBLEM_TEXT[0];
    return $specificProblemText; 
}

// //NOT USED
// const OTU_RES_NAME_UNKNOWN_CODE=0; //cOtu_Res_Name_Unknown
// const OTU_RES_NAME_BASE_CODE=1;   						// Associes a la ressource UNIT
// const OTU_RES_NAME_OPTICAL_MODULE_CODE=2;
// const OTU_RES_NAME_INTERNAL_OTAU_CODE=3;
// const OTU_RES_NAME_EXTERNAL_OTAU_CODE=4;
// const OTU_RES_NAME_RELAY_CARD_CODE=5;
// const OTU_RES_NAME_MODEM_CODE=6;
// const OTU_RES_NAME_NETWORK_CODE=50;   	   // Associes a la ressource COM
// const OTU_RES_NAME_NETWORK_MODEM_CODE=51;
// const OTU_RES_NAME_SMS_CODE=52;
// const OTU_RES_NAME_EMAIL_CODE=53;
// const OTU_RES_NAME_SERVER_CODE=54;

// /**
//  * System alarm resource name
//  * Wraps tOtu_Alarm_Ressource_Name
//  * @var array
//  */
// private static $SYSTEM_ALARM_RESSOURCE_NAME = array(
// 		self::OTU_RES_NAME_UNKNOWN_CODE=>OTU_RES_NAME_UNKNOWN, // 0   //cOtu_Res_Name_Unknown
// 		OTU_RES_NAME_BASE,   						// Associes a la ressource UNIT
// 		OTU_RES_NAME_OPTICAL_MODULE,
// 		OTU_RES_NAME_INTERNAL_OTAU,
// 		OTU_RES_NAME_EXTERNAL_OTAU,
// 		OTU_RES_NAME_RELAY_CARD,
// 		OTU_RES_NAME_MODEM,
// 		self::OTU_RES_NAME_NETWORK_CODE=>OTU_RES_NAME_NETWORK, //50  	   // Associes a la ressource COM
// 		OTU_RES_NAME_NETWORK_MODEM,
// 		OTU_RES_NAME_SMS,
// 		OTU_RES_NAME_EMAIL,
// 		OTU_RES_NAME_SERVER );//tOtu_Alarm_Ressource_Name
// /**
//  * @param integer $originatingResourceCode
//  * @return string
//  */
// public static function decodeSystemAlarmResourceName( $originatingResourceCode )
// {
// 	return ( self::$SYSTEM_ALARM_RESSOURCE_NAME[$originatingResourceCode] != NULL) ? self::$SYSTEM_ALARM_RESSOURCE_NAME[$originatingResourceCode] :self::$SYSTEM_ALARM_RESSOURCE_NAME[0];
// }

}
?>