<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of Viavi Solution
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from Viavi Solution
// Copyright Viavi Solution 2019. All rights reserved.
// *********************************************************
namespace app\services\api;



class SMTApiOtuDto extends SMTApiDto
{
	/**
	 * OTU serial number
	 *
	 * @var string
	 */
	protected $serialNumber;
	
	/**
	 * OTU type label
	 * @var string
	 */
	protected $type;
	
	/**
	 * Optical module type
	 * @var string
	 */
	protected $moduleType;
	
	/**
	 * OTU port number
	 * @var integer
	 */
	protected $portCount;
	
	/**
	 * OTU current date in UTC
	 * @var integer
	 */
	protected $date;
	/**
	 * OTU release version
	 * @var string
	 */
	protected $softwareVersion;
	
	/**
	 * OTU licenses list
	 * @var string
	 */
	protected $licenses;
	
	
	
	public function setSerialNumber($serialNumber)
	{
		$this->serialNumber= $serialNumber;
	}
	
	/**
	 * OTU release version
	 *
	 * @param string $otuReleaseVersion
	 */
	public function setSoftwareVersion( $otuReleaseVersion )
	{
		$this->softwareVersion = $otuReleaseVersion;
	}
	
	/**
	 * OTU type
	 *
	 * @param string $otuType
	 */
	public function setType( $otuType )
	{
		$this->type = $otuType;
	}
	
	/**
	 * OTU optical module type
	 *
	 * @param string $otuType
	 */
	public function setModuleType( $otuModuleType )
	{
		$this->moduleType= $otuModuleType;
	}
	
	/**
	 * OTU port count
	 *
	 * @param string $otuType
	 */
	public function setPortCount( $portCount)
	{
		$this->portCount= intval($portCount);
	}
	/**
	 * OTU date
	 *
	 * @param integer $date
	 */
	public function setDate( $date)
	{
		$this->date= intval($date);
	}
	/**
	 * OTU software licenses
	 *
	 * @param string $license
	 */
	public function setLicense( $license )
	{
		$this->licenses= $license;
	}
	
	/**
	 * Serialize as Json data the user object.<br>
	 *
	 * @return $objectProperties the object properties serialized as a Json string.
	 */
	function getJsonData()
	{
		$objectProperties = get_object_vars($this);
		$this->serializeObjectAsJsonData( $objectProperties, FALSE);
		return $objectProperties;
	}
	
	/**
	 * Returns Dto class name.
	 *
	 * @return string the dtop class name
	 */
	function getDtoClassName()
	{
		return get_class();
	}
}