<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\events;

use app\util\SMTDto;

class SMTMessageCarrierDto extends SMTDto
{    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\events\SMTOpticalAlarmMessageDto',islist='true')
     * @var app\events\SMTOpticalAlarmMessageDto[]
     */
    protected $opticalAlarmMessages = array();
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\events\SMTSystemAlarmMessageDto',islist='true')
     * @var app\events\SMTSystemAlarmMessageDto[]
     */
    protected $systemAlarmMessages = array();    
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\events\SMTActivityMessageDto',islist='true')
     * @var app\events\SMTActivityMessageDto[]
     */
    protected $activityMessages = array();
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\events\SMTLinkTestUpdateMessageDto',islist='true')
     * @var app\events\SMTLinkTestUpdateMessageDto[]
     */
    protected $linkTestUpdateMessages = array();
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\events\SMTMeasureOnDemandMessageDto',islist='true')
     * @var Array of app\events\SMTMeasureOnDemandMessageDto
     */
    protected $measureOnDemandMessages = array();    
    
    /**
     * @SMTAttributeInfosAnnotation(classname='app\events\SMTTestOnDemandMessageDto',islist='true')
     * @var app\events\SMTTestOnDemandMessageDto[]
     */
    protected $testOnDemandMessages = array();    

    
    public function addOpticalAlarmMessage( SMTOpticalAlarmMessageDto $message )
    {
    	if ( $message != NULL )
    	{
    		array_push( $this->opticalAlarmMessages, $message);
    	}
    }
    
    public function getOpticalAlarmMessages()
    {
    	return $this->opticalAlarmMessages;
    }
    
    public function hasOpticalAlarmMessages()
    {
    	return count( $this->opticalAlarmMessages ) > 0;
    }
    
    public function addSystemAlarmMessage( SMTSystemAlarmMessageDto $message )
    {
    	if ( $message != NULL )
    	{
    		array_push( $this->systemAlarmMessages, $message);
    	}
    }
    
    public function getSystemAlarmMessages()
    {
    	return $this->systemAlarmMessages;
    }
    
    public function hasSystemAlarmMessages()
    {
    	return count( $this->systemAlarmMessages ) > 0;
    }    
    
    public function addActivityMessage( SMTActivityMessageDto $message )
    {
    	if ( $message != NULL )
    	{
    		array_push( $this->activityMessages, $message);
    	}
    }
    
    public function getActivityMessages()
    {
    	return $this->activityMessages;
    }
    
    public function hasActivityMessages()
    {
    	return count( $this->activityMessages ) > 0;
    }
    
    public function addLinkTestUpdateMessage( SMTLinkTestUpdateMessageDto $message )
    {
    	if ( $message != NULL )
    	{
    		array_push( $this->linkTestUpdateMessages, $message);
    	}
    }
    
    /**
     * 
     * @return \app\events\SMTLinkTestUpdateMessageDto[]
     */
    public function getLinkTestUpdateMessages()
    {
    	return $this->linkTestUpdateMessages;
    }
    
    public function hasLinkTestUpdateMessages()
    {
    	return count( $this->linkTestUpdateMessages ) > 0;
    }    

    public function addMeasureOnDemandMessage( SMTMeasureOnDemandMessageDto $message )
    {
    	if ( $message != NULL )
    	{
    		array_push( $this->measureOnDemandMessages, $message);
    	}
    }
    
    public function getMeasureOnDemandMessages()
    {
    	return $this->measureOnDemandMessages;
    }
    
    public function hasMeasureOnDemandMessages()
    {
    	return count( $this->measureOnDemandMessages ) > 0;
    }

    public function addTestOnDemandMessage( SMTTestOnDemandMessageDto $message )
    {
    	if ( $message != NULL )
    	{
    		array_push( $this->testOnDemandMessages, $message);
    	}
    }
    
    public function getTestOnDemandMessages()
    {
    	return $this->testOnDemandMessages;
    }
    
    public function hasTestOnDemandMessages()
    {
    	return count( $this->testOnDemandMessages ) > 0;
    }  
    
    public function hasMessages()
    {
    	return $this->hasActivityMessages() || $this->hasOpticalAlarmMessages() || $this->hasSystemAlarmMessages() || $this->hasTestOnDemandMessages() || $this->hasMeasureOnDemandMessages() || $this->hasLinkTestUpdateMessages();
    }

    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    public function getDtoClassName()
    {
    	return get_class();
    }
} 

?>