from viavi.evm import *
from viavi.diag import *  # needed to define RESOURCE name and sysfs_* functions (see /usr/lib/python3.5/jdsu/diag/)
# from time import time, localtime, sleep            # needed for sleep()
from time import sleep
import time
from jdsu.mts.uts_bdt import UtsBdt  # seels jdsu/mts/uts_bdt.py or /usr/lib/python3.5/jdsu/mts/uts_bdt.py
from jdsu.mts.evdev import InputDevice
import select
import os
import os.path
import subprocess
import struct  # to use unpack method
import hashlib
from .eotdrv2_regs import *  # Needed for REG_DAC_VCC_APD definition
from jdsu.mts.pca9535 import PCA9535  # see /usr/lib/python2.7/jdsu/mts/pca9535.py
import traceback
import smbus
import serial

#
# ===================================================================================================================
# print_info, print_error defined into /usr/lib/python3.5/jdsu/tools/tools.py
# ===================================================================================================================
#

#
# ===================================================================================================================
# create my_B84 for debug
# ===================================================================================================================
#
class my_B84:
    def __init__(self):
        self.name = "toto"
        self.value = 1

        for io in (0, 7):
            print_info("setPortOut(0,%d,0)" % (io))
            print_info("setPortOut(1,%d,0)" % (io))

    def setOtuSpare0(self, io_val):
        print("setOtuSpare0", io_val)

    def setDyingIrq(self, io_val):
        print("setDyingIrq", io_val)

    def setFan3Tach(self, io_val):
        print("setFan3Tach", io_val)

    def setFan2Tach(self, io_val):
        print("setFan2Tach", io_val)

    def setFan1Tach(self, io_val):
        print("setFan1Tach", io_val)

    def setOtuSpare1(self, io_val):
        print("setOtuSpare1", io_val)

    def setOtuSpare2(self, io_val):
        print("setOtuSpare2", io_val)

    def setUartOtuRx(self, io_val):
        print("setUartOtuRx", io_val)

    def getChecksumInputs(self):
        #		val = (self.pca._i2c.read_byte_data(self.pca._pca_adress,self.pca.INPUT_PORT_0) & 0x1C) + ((self.pca._i2c.read_byte_data(self.pca._pca_adress,self.pca.INPUT_PORT_1) & 0xA3) << 8)
        val = 0xa5c7
        print_info("#val = %d = 0x%x" % (val, val))
        val = val & ~0x0004
        print_info("#val_masked = %d = 0x%x" % (val, val))
        # remove SYNC_PSU
        nb1 = 0
        for i in range(0, 15):
            nb1 = nb1 + ((val >> i) & 0x0001)
            print_info("i = %d : val = 0x%x => val >> i = 0x%x ; nb1 = %d" % (i, val, (val >> i), nb1))
        print("\n")
        return nb1


# ==================================================================================================


@DIAG("Test COTU Fan")
def t_cotu_fan(cmd):
    test_has_failed = False
    gpio_base = 906 + 54  # start for gpio in fpga
    gpio_table = [
        {'name': 'GPIO_OTU_FAN1', 'gpio': gpio_base + 13, 'dir': 'out', 'opposite_pin': 'gpio_b87_fan1_otu_on'},
        {'name': 'GPIO_OTU_FAN2', 'gpio': gpio_base + 14, 'dir': 'out', 'opposite_pin': 'gpio_b87_fan2_otu_on'},
        {'name': 'GPIO_OTU_FAN3', 'gpio': gpio_base + 15, 'dir': 'out', 'opposite_pin': 'gpio_b87_fan3_otu_on'},
        {'name': 'GPIO_OTU_FAN_TACH1', 'gpio': gpio_base + 17, 'dir': 'in', 'opposite_pin': 'gpio_b87_fan1_otu_tach'},
        {'name': 'GPIO_OTU_FAN_TACH2', 'gpio': gpio_base + 18, 'dir': 'in', 'opposite_pin': 'gpio_b87_fan2_otu_tach'},
        {'name': 'GPIO_OTU_FAN_TACH3', 'gpio': gpio_base + 19, 'dir': 'in', 'opposite_pin': 'gpio_b87_fan3_otu_tach'},
    ]
#        {'name': 'GPIO_OTU_FAN_PWM', 'gpio': gpio_base + 16, 'dir': 'out', 'opposite_pin': 'gpio_b87_fan_otu_pwm'},
    print_info("Configuring GPIOs")
    # configure GPIOs and init everything to 0
    try:
        for gpio in gpio_table:
            sysfs_write("/sys/class/gpio/export", gpio['gpio'])
            sysfs_write("/sys/class/gpio/gpio%d/direction" % (gpio['gpio']), gpio['dir'])
            if gpio['dir'] == 'out':
                sysfs_write("/sys/class/gpio/gpio%d/value" % (gpio['gpio']), 0)
        # Init B87 gpio output to 0
        for gpio in gpio_table:
            if gpio['dir'] == 'in':
                sysfs_write("/sys/platform/{}/value".format(gpio['opposite_pin']), 0)

    except Exception as excp:
        print_error("Error during gpio configuration : " + str(excp))
        traceback.print_exc()
        # Free resources
        for gpio in gpio_table:
            sysfs_write("/sys/class/gpio/unexport", gpio['gpio'])
        return False

    print_info("Testing each GPIO")
    for gpio in gpio_table:
        print_info("Checking %s" % gpio['name'])
        try:
            # put associate output to 1
            if gpio['dir'] == 'out':
                sysfs_write("/sys/class/gpio/gpio%d/value" % (gpio['gpio']), 1)
            else:
                sysfs_write("/sys/platform/{}/value".format(gpio['opposite_pin']), 1)
            sleep(0.1)
        except Exception as excp:
            print_error("Critical error during FAN GPIO test : " + str(excp))
            test_has_failed = True
            continue
        try:
            # check only this gpio has changed
            for check_gpio in gpio_table:
                if check_gpio['name'] != gpio['name']:
                    expected_value = 0
                else:
                    expected_value = 1

                if check_gpio['dir'] == 'in':
                    gpio_value = sysfs_read("/sys/class/gpio/gpio%d/value" % check_gpio['gpio'])
                else:
                    gpio_value = sysfs_read("/sys/platform/{}/value".format(check_gpio['opposite_pin']))

                if gpio_value != expected_value:
                    print_error("Error during test of gpio {}, gpio {} has not the right value, expected: "
                                .format(gpio['name'], check_gpio['name'], expected_value))
                    test_has_failed = True
        except Exception as excp:
            print_error("Critical error during FAN GPIO test : " + str(excp))
            test_has_failed = True

        # reset the gpio state
        if gpio['dir'] == 'out':
            sysfs_write("/sys/class/gpio/gpio%d/value" % (gpio['gpio']), 0)
        else:
            sysfs_write("/sys/platform/{}/value".format(gpio['opposite_pin']), 0)
        sleep(0.1)

    print_info("Freeing GPIOs")
    # Free resources
    for gpio in gpio_table:
        sysfs_write("/sys/class/gpio/unexport", gpio['gpio'])
    if test_has_failed:
        return False
    else:
        return True


@DIAG("Test COTU Connector other")
def t_cotu_connector_test(cmd):
    GPIO_BASE = 906 + 54
    GPIO_DYING = GPIO_BASE + 26  # out
    GPIO_MODE_DIAG = GPIO_BASE + 27  # out
    GPIO_DIAG_UART_DTR = GPIO_BASE + 28  # in
    GPIO_DIAG_UART_RX = GPIO_BASE + 29  # out
    GPIO_DIAG_UART_TX = GPIO_BASE + 30  # in
    GPIO_OTU_SPARE0 = GPIO_BASE + 1  # out
    GPIO_OTU_SPARE1 = GPIO_BASE + 2  # out
    GPIO_OTU_SPARE2 = GPIO_BASE + 3  # out
    GPIO_OTU_FAN1 = GPIO_BASE + 13  # in
    GPIO_OTU_FAN2 = GPIO_BASE + 14  # in
    GPIO_OTU_FAN3 = GPIO_BASE + 15  # in
    GPIO_OTU_FAN_PWM = GPIO_BASE + 16  # in
    GPIO_OTU_FAN_TACH1 = GPIO_BASE + 17  # out
    GPIO_OTU_FAN_TACH2 = GPIO_BASE + 18  # out
    GPIO_OTU_FAN_TACH3 = GPIO_BASE + 19  # out
    GPIOS_84_TO_EOTDR = (("DyingIrq", "setDyingIrq", "/sys/class/gpio/gpio%d/value" % (GPIO_DYING)), \
                         ("OtuSpare0", "setOtuSpare0", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_SPARE0)), \
                         ("OtuSpare1", "setOtuSpare1", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_SPARE1)), \
                         ("OtuSpare2", "setOtuSpare2", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_SPARE2)), \
                         ("Fan1Tach", "setFan1Tach", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_FAN_TACH1)), \
                         ("Fan2Tach", "setFan2Tach", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_FAN_TACH2)), \
                         ("Fan3Tach", "setFan3Tach", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_FAN_TACH3)), \
                         ("UartOtuRx", "setUartOtuRx", "/sys/class/gpio/gpio%d/value" % (GPIO_DIAG_UART_RX)))

    GPIOS_EOTDR_TO_84 = (("Fan1OtuOn", "getFan1OtuOn", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_FAN1)), \
                         ("FanPWM", "getFanPWM", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_FAN_PWM)), \
                         ("Fan3OtuOn", "getFan3OtuOn", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_FAN3)), \
                         ("Fan2OtuOn", "getFan2OtuOn", "/sys/class/gpio/gpio%d/value" % (GPIO_OTU_FAN2)), \
                         ("UartOtuDtr", "getUartOtuDtr", "/sys/class/gpio/gpio%d/value" % (GPIO_DIAG_UART_DTR)), \
                         ("UartOtuTx", "getUartOtuTx", "/sys/class/gpio/gpio%d/value" % (GPIO_DIAG_UART_TX)))

    b84 = my_B84()

    print_info("GPIO_BASE = %d = 0x%x" % (GPIO_BASE, GPIO_BASE))
    for (gpioName, gpioSetB84, gpioGetEotdr) in GPIOS_84_TO_EOTDR:
        print("gpioName = ", gpioName, "gpioSetB84 = ", gpioSetB84, "gpioGetEotdr = ", gpioGetEotdr)
        getattr(b84, gpioSetB84)(0)
        getattr(b84, gpioSetB84)(1)

    if (b84.getChecksumInputs() > 0):
        passed = False
        print_error("#Fail verif init all 0")


#
# =============================================================================================
#
def cOTU_DCDC_temperature(dlist):
    try:
        my_choice = False
        # print(dlist)

        if my_choice:
            my_list_lgth = len(dlist)
            print(my_list_lgth)
            temp_str = dlist[my_list_lgth - 2]
            print("temp_str = ", temp_str)
            temp_value_list = temp_str.split("=")
            print(temp_value_list)
            temp_value = float(temp_value_list[1]) / 1000
            print("temp_value = %2.3f" % temp_value)
        else:
            for elt in enumerate(dlist):
                # my_tuple = elt
                # print("...", my_tuple)
                # my_t_tuple_ind,  my_t_tuple_str = my_tuple
                my_t_tuple_ind, my_t_tuple_str = elt
                # print("..........", my_t_tuple_ind, my_t_tuple_str, my_t_tuple_str[:2])
                if my_t_tuple_str[:2] == "t=":
                    temp_str1 = my_t_tuple_str
                # print(temp_str1)
        temp_value = float(temp_str1.split("=")[1]) / 1000
    # print("temp_value = %2.3f" %temp_value )
    # time.sleep(10)

    except:
        temp_value = -99.0

    return (temp_value)

@DIAG("Set OFF all front panel leds")
def t_led_off(cmd):
    LED_TYPES = ["optic", "unit", "server", "status", "testing"]
    LED_COLOR = ["red", "green"]
    for type in LED_TYPES:
        for color in LED_COLOR:
            sysfs_write("/sys/class/leds/led_" + type + "_" + color + "/brightness", 0)
            sysfs_write("/sys/class/leds/led_" + type + "_" + color + "/trigger", "none")


#
# =============================================================================================
#
# t_led_test OPTIC-GREEN-ON
# t_led_test OPTIC-GREEN-OFF
# t_led_test OPTIC-RED-ON
# t_led_test OPTIC-RED-OFF
#
# t_led_test UNIT-GREEN-ON
# t_led_test UNIT-GREEN-OFF
# t_led_test UNIT-RED-ON
# t_led_test UNIT-RED-OFF
#
# t_led_test SERVER-GREEN-ON
# t_led_test SERVER-GREEN-OFF
# t_led_test SERVER-RED-ON
# t_led_test SERVER-RED-OFF
#
# t_led_test STATUS-GREEN-ON
# t_led_test STATUS-GREEN-OFF
# t_led_test STATUS-RED-ON
# t_led_test STATUS-RED-OFF
#
# t_led_test TESTING-GREEN-ON
# t_led_test TESTING-GREEN-OFF
# t_led_test TESTING-RED-ON
# t_led_test TESTING-RED-OFF
# =============================================================================================
#

@DIAG("Set ON/OFF front panel leds")
def t_led_test(cmd):
    LED_TYPES = ["OPTIC", "UNIT", "SERVER", "STATUS", "TESTING"]
    LED_COLOR = ["RED", "GREEN"]

    try:
        (dummy, consigne) = cmd.split()
        (led_type, led_color, on_off_flag) = consigne.split('-')
        print("led_type = %s ; led_color = %s ; on_off_flag = %s" % (led_type, led_color, on_off_flag))

    except:
        print_error(
            "# Command must be: t_led_test <consigne> where <consigne> is <LED_TYPE>-<LED_COLOR>-<ON_OFF_FLAG> with <LED_TYPE> = OPTIC|UNIT|SERVER|STATUS|TESTING and <LED_COLOR> = RED|GREEN and <ON_OFF_FLAG> =  ON|OFF")
        return False

    # print_info("# VERSION: 0.0.1")
    time.sleep(0.6)

    if led_type not in LED_TYPES:
        print("led_type is Unknown")
        return False

    if led_color not in LED_COLOR:
        print("led_color is undefined")
        return False

    if on_off_flag == "ON":
        s = "1"
        msg = "Set_on"
    elif on_off_flag == "OFF":
        s = "0"
        msg = "Clear"
    else:
        print("on_off_flag is undefined")
        return False

    color_str = led_color.lower()
    led_type_str = led_type.lower()
    print("%s led %s %s " % (msg, led_type_str, color_str))

    sysfs_write("/sys/class/leds/led_" + led_type_str + "_" + color_str + "/brightness", s)

    sleep(0.5)

    return True


#
# =============================================================================================
#
# t_48V_pwr_supply_status FRONT;RIGHT
# t_48V_pwr_supply_status FRONT;LEFT
# t_48V_pwr_supply_status FRONT;BOTH
# t_48V_pwr_supply_status REAR;RIGHT
# t_48V_pwr_supply_status REAR;LEFT
# t_48V_pwr_supply_status REAR;BOTH
# t_48V_pwr_supply_status BOTH;RIGHT
# t_48V_pwr_supply_status BOTH;LEFT
# t_48V_pwr_supply_status BOTH;BOTH
#
# =============================================================================================
#
@DIAG("48V Power supply status readback")
def t_48V_pwr_supply_status(cmd):
    try:
        (command, consigne) = cmd.split()
        print("command = ", command, "consigne = ", consigne)

        my_string = consigne.split(";")
        print("my_string = ", my_string)

        (panel_loc, side) = consigne.split(';')

        if panel_loc == "FRONT" or panel_loc == "REAR" or panel_loc == "BOTH":
            print("panel_loc is OK")
        else:
            print("KO : Unknown panel_loc")
            return False

        if side == "RIGHT" or side == "LEFT" or side == "BOTH":
            print("DV : side is OK")
        else:
            print("KO : Unknown side")
            return False

    except:
        print_error(
            "# Command must be: t_48V_pwr_supply_status <consigne> where <consigne> is <PANEL_LOC>;<SIDE> with <PANEL_LOC> = FRONT|REAR|BOTH and <SIDE> = RIGHT|LEFT|BOTH")
        return False

    # print_info("# VERSION: 0.0.1")
    time.sleep(0.6)

    panel_loc_str = panel_loc.lower()
    side_str = side.lower()

    if panel_loc_str == "both":
        front_panel_loc = True
        rear_panel_loc = True
    else:
        if panel_loc_str == "front":
            front_panel_loc = True
            rear_panel_loc = False
        else:
            front_panel_loc = False
            rear_panel_loc = True

    if side_str == "both":
        right_side = True
        left_side = True
    else:
        if side_str == "right":
            right_side = True
            left_side = False
        else:
            right_side = False
            left_side = True

    if front_panel_loc:
        panel_loc_str = "front"
        if right_side:
            side_str = "right"
            print("Readback <%s> power supply <%s> side :" % (panel_loc_str, side_str))
            pwr_value_str = sysfs_read_string("/sys/platform/pwr_" + panel_loc_str + "_" + side_str + "/value")
            print_info("Readback value =  %s" % (pwr_value_str))

        if left_side:
            side_str = "left"
            print("Readback <%s> power supply <%s> side :" % (panel_loc_str, side_str))
            pwr_value_str = sysfs_read_string("/sys/platform/pwr_" + panel_loc_str + "_" + side_str + "/value")
            print_info("Readback value =  %s" % (pwr_value_str))

    if rear_panel_loc:
        panel_loc_str = "rear"
        if right_side:
            side_str = "right"
            print("Readback <%s> power supply <%s> side :" % (panel_loc_str, side_str))
            pwr_value_str = sysfs_read_string("/sys/platform/pwr_" + panel_loc_str + "_" + side_str + "/value")
            print_info("Readback value =  %s" % (pwr_value_str))

        if left_side:
            side_str = "left"
            print("Readback <%s> power supply <%s> side :" % (panel_loc_str, side_str))
            pwr_value_str = sysfs_read_string("/sys/platform/pwr_" + panel_loc_str + "_" + side_str + "/value")
            print_info("Readback value =  %s" % (pwr_value_str))

    return None


#
# ls-l /dev/i2c*
#
# i2cdetect -y -r 1    # 1 is the bus_name
# i2cdetect -F 1
# i2cdump -y 1 0x52
#
@DIAG("i2c device detection")
def t_cotu_i2cdetect(cmd):
    print("\n================")
    print("**** i2c-0 bus:")
    print("================\n")
    bus0_my_list = (os.system("i2cdetect -y -r 0"))
    print(bus0_my_list)

    print("\n================")
    print("**** i2c-1 bus:")
    print("================\n")
    os.system("i2cdetect -y -r 1")

    return True


@DIAG("i2c eeprom read")
def t_cotu_eeprom_read(cmd):
    cmd = subprocess.run("i2cdump -y 1 0x52", stdout=subprocess.PIPE, shell=True, stderr=subprocess.PIPE)
    if cmd.returncode != 0:
        return False
    # If the device can't be read, XX will be used on dumped output
    for line in cmd.stdout.decode("utf-8").split('n'):
        if 'XXXXXXXX' in line:
            return False
    return True


@DIAG("Get eotdrv2 1wire Address")
def t_eotdrv2_onewire(cmd):
    res = sysfs_check("/sys/bus/w1/devices/w1_bus_master1/w1_master_slave_count", "OneWire Slave count",
                      vmin=int(CONST("onewire.slavecount", 1)), vmax=int(CONST("onewire.slavecount", 1)))
    if res:
        # to extract onewire_ids
        sn = sysfs_read_string("/sys/bus/w1/devices/w1_bus_master1/w1_master_slaves")
        my_list = sn.split(" ")
        my_list_lgth = len(my_list)
        print(my_list)
        print_info("# ID: %s" % sn)
        return True
    return False


@DIAG("Get cOTU 1wire Address")
def t_cotu_onewire(cmd):
    res = sysfs_check("/sys/bus/w1/devices/w1_bus_master2/w1_master_slave_count", "OneWire Slave count",
                      vmin=int(CONST("onewire.slavecount", 1)), vmax=int(CONST("onewire.slavecount", 2)))
    print(
        "master_slave_count = %d" % int(sysfs_read_string("/sys/bus/w1/devices/w1_bus_master2/w1_master_slave_count")))
    if res:
        # to extract onewire_ids
        sn = sysfs_read_string("/sys/bus/w1/devices/w1_bus_master2/w1_master_slaves")
        my_list = sn.split(" ")
        my_list_lgth = len(my_list)
        # print("my_list = %s => lgth = %d" %(my_list,my_list_lgth))
        for elt in enumerate(my_list):
            my_t_tuple_ind, my_t_tuple_str = elt
            # print("..........", my_t_tuple_ind, my_t_tuple_str)
            id_str = my_t_tuple_str.split("-")[0]
            if not id_str == "":
                if id_str == "23":
                    msg = " => OneWire eeprom device"
                elif id_str == "28":
                    msg = " => OneWire temperature sensor device"
                else:
                    msg = " => OneWire unknown device"
                print_info("# ID: %s %s" % (id_str, msg))

        return True
    return False


@DIAG("Get temp sensor 1wire Address")
def t_onewire_temp_sensor(cmd):
    res = sysfs_check("/sys/bus/w1/devices/w1_bus_master2/w1_master_slave_count", "OneWire Slave count",
                      vmin=int(CONST("onewire.slavecount", 1)), vmax=int(CONST("onewire.slavecount", 2)))

    fileName = 'DCDC_temp' + '.csv'
    open('running', 'a').close()

    print('\n****** Mesures en boucles: effacer fichier running pour arreter ******\n')

    with open(fileName, 'w') as f:
        f.write('Heure;Tmod;Tcpu;Inj;DynIEC;DynRMS\n')
        while os.path.isfile('running'):
            if res:
                sn = sysfs_read_string("/sys/bus/w1/devices/w1_bus_master2/w1_master_slaves")
                my_list = sn.split(" ")
                my_list_lgth = len(my_list)
                print_info("# ID: %s" % sn)

                i = 0
                loop_i = 1
                while os.path.isfile('running') and (i < 1):
                    sn = sysfs_read_string("/sys/bus/w1/devices/28-000009048fd1/w1_slave")
                    if loop_i == 1:
                        print_info("#%s" % sn)

                    my_list = sn.split(" ")
                    dcdc_temp = cOTU_DCDC_temperature(my_list)
                    heure = '%2d:%2d' % (time.localtime().tm_hour, time.localtime().tm_min)
                    if (loop_i == 1) or (loop_i % 10 == 0):
                        print("loop_i : %d : heure = %s : dcdc_temp = %3.3f" % (loop_i, heure, dcdc_temp))
                    f.write('%s;%3.3f\n' % (heure, dcdc_temp))
                    time.sleep(30)
                    loop_i += 1

                return True
            f.close()

            return False


#
# =============================================================================================
#
# t_osx_pwr_sply_test ON
# t_osx_pwr_sply_test OFF
#
# =============================================================================================

@DIAG("Set ON/OFF OSX power supply")
def t_osx_pwr_sply_test(cmd):
    try:
        (command, consigne) = cmd.split()
        print("command = ", command, "consigne = ", consigne)

    # my_string = consigne.split('-')
    # print("my_string = ", my_string)

    # (led_type, led_color, on_off_flag) = consigne.split('-')
    # print("led_type = %s ; led_color = %s ; on_off_flag = %s" %(led_type, led_color, on_off_flag))

    except:
        print_error(
            "# Command must be: t_led_test <consigne> where <consigne> is <ON_OFF_FLAG> with <ON_OFF_FLAG> =  ON|OFF")
        return False

    # print_info("# VERSION: 0.0.1")
    time.sleep(0.6)

    if consigne == "ON":
        s = "1"
        msg = "Set_on"
    else:
        s = "0"
        msg = "Set_off"

    print("%s osx power supply" % msg)

    # sysfs_write("/sys/platform/gpio_en_alim_switch", s)

    sysfs_write("/sys/platform/gpio_en_alim_osx/value", s)

    return None


@DIAG("Set ON/OFF Optical Switch power supply")
def t_opsw_pwr_sply_test(cmd):
    try:
        (command, consigne) = cmd.split()
        print("command = ", command, "consigne = ", consigne)

    # my_string = consigne.split('-')
    # print("my_string = ", my_string)

    # (led_type, led_color, on_off_flag) = consigne.split('-')
    # print("led_type = %s ; led_color = %s ; on_off_flag = %s" %(led_type, led_color, on_off_flag))

    except:
        print_error(
            "# Command must be: t_led_test <consigne> where <consigne> is <ON_OFF_FLAG> with <ON_OFF_FLAG> =  ON|OFF")
        return False

    # print_info("# VERSION: 0.0.1")
    time.sleep(0.6)

    if consigne == "ON":
        s = "1"
        msg = "Set_on"
    else:
        s = "0"
        msg = "Set_off"

    print("%s optical switch power supply" % msg)

    # sysfs_write("/sys/platform/gpio_en_alim_switch", s)

    sysfs_write("/sys/platform/gpio_en_alim_switch/value", s)

    return None



@DIAG("Test osx communication port")
def t_cotu_osx(cmd):
    TTYOSX = '/dev/ttyS0'
    OSX_IDN_QUERY = bytes([0x81, 0x01, 0x00, 0x00, 0x02, 0x00, 0x01, 0x00, 0x6a, 0xdc])

    ser = serial.Serial(TTYOSX, 2400, timeout=5)
    if ser is None:
        print_error("No RS485 port found")
        return False
    # Send the idn command
    ser.write(OSX_IDN_QUERY)
    ser.flush()

    # Read the ACK
    data = ser.read()
    if data != b'\x81':
        print_error("No response from OSX")
        return False
    data = ser.read(3)
    if data != bytes([0x0, 0x1, 0x1]):
        print_error("Bad Ack frame")
        return False

    # Read the IDN response
    data = ser.read()
    if data != b'\x81':
        print_error("No response at idn query from OSX")
        return False
    data = ser.read(5)
    if len(data) != 5:
        print_error("idn response corrupted")
        return False
    payload_length = data[3]
    payload = ser.read(payload_length)
    if len(payload) < payload_length:
        print_error("Not enough payload")
        return False
    start_payload = bytearray(payload)[3:]
    result = False
    if start_payload[0:7] == bytearray("SKC FP1".encode()):
        result = True
    else:
        print_error("Failure idn response doesn't match template: received = {} - expected = {}".format(
            start_payload[0:6],
            bytearray("SKC FP1".encode()))
        )

    # Send ack for the idn reception
    ser.write(bytes([0x81, 0x01, 0x00, 0x01]))
    ser.flush()
    ser.close()

    return result
