#!/bin/sh
ACTION=$1
shift
PARAM=$*
XSCREENSAVER_CONF_DIR=/usr/local/share/xscreensaver
XSCREENSAVER_CONF=/root/.xscreensaver
if [ ! -e /tmp/runnig_on_ac ]; then
  WAS_ON_BATTERY=1
fi
case "$ACTION" in
    timeout)
		echo $PARAM > $XSCREENSAVER_CONF_DIR/timeout
    ;;
    powerchange)    
	NEW_VEXT=$1
	if [ "$NEW_VEXT" = "0" ]; then
		rm -f /tmp/runnig_on_ac
	else
		touch /tmp/runnig_on_ac
	fi
    ;;
   *)
	exit 1
    ;;
esac

TIMEOUT=$(cat $XSCREENSAVER_CONF_DIR/timeout)
if [ -z "$TIMEOUT" ] ; then 
	TIMEOUT="00:00:00"
fi

if [ -e /tmp/runnig_on_ac ]; then
	cat $XSCREENSAVER_CONF_DIR/xscreensaver.conf | sed  "s/^dpmsStandby.*/dpmsStandby: $TIMEOUT/g" | sed  "s/^timeout.*/timeout: $TIMEOUT/g" | sed  "s/.*dpmsEnabled:.*/dpmsEnabled: False/g" > $XSCREENSAVER_CONF
else
	cat $XSCREENSAVER_CONF_DIR/xscreensaver.conf | sed  "s/^dpmsStandby.*/dpmsStandby: $TIMEOUT/g" | sed  "s/^timeout.*/timeout: $TIMEOUT/g" | sed  "s/.*dpmsEnabled:.*/dpmsEnabled: True/g" > $XSCREENSAVER_CONF
fi

WAS_BLANKED="$(xscreensaver-command -time | grep 'non-blanked')"

#we could use xscreensaver-command --restart but somehow it doesn't seem to behave properly where dpms is concerned. so we stop the screesaver and if needed start it again
xscreensaver-command --exit
if [ "$TIMEOUT"  != "00:00:00" ] ; then
  xscreensaver&
# #if the screen saver is blanked, we need to cycle to the next program to have it take in account our changes
# if [ -z $WAS_BLANKED ] ; then
#   xscreensaver-command --activate
# fi
else
  #make sure that the DPMS is disabled. Since the screensaver is not restarted, the dpms settings of X is not updated 
  xset -dpms
fi


