import QtQuick 2.10
pragma Singleton

QtObject{
    id: root

    // Source: https://viavicentral.viavisolutions.com/docs/DOC-6212

    // Primary Color
    readonly property color viaviPurple: "#500778"
    readonly property color darkBlue:    "#0040a6"
    readonly property color mediumBlue:  "#426da9"
    readonly property color lightBlue:   "#00a9e0"
    readonly property color blueGreen:   "#00b0a2"

    // Secondary Color
    readonly property color burgundy:   "#8a1b61"
    readonly property color red:        "#d50032"
    readonly property color orange:     "#e87722"
    readonly property color yellow:     "#ffb500"
    readonly property color green:      "#2cb34a"

    // Tertiary colors
    readonly property color darkGray:   "#333333"
    readonly property color mediumGray: "#999999"
    readonly property color lightGray3: "#c6c6c6"
    readonly property color lightGray2: "#dbdbdb"
    readonly property color lightGray1: "#f2f2f2"
    readonly property color darkerBlue: "#1a2b58"
    readonly property color deepBlue:   "#000c2b"
    readonly property color black:      "#000000"
    readonly property color white:      "#ffffff"


    // Tranparent color
    readonly property color transparent: "transparent"

    // General
    readonly property alias alarmFail: root.red
    readonly property alias alarmPass: root.green
    readonly property alias alarmWarning: root.orange
    readonly property alias background: root.lightGray1
    readonly property alias border: root.black
    readonly property alias clickable: root.viaviPurple
    readonly property alias darkForground: root.darkGray
    readonly property alias forground: root.white
    readonly property alias info: root.darkGray
    readonly property alias title: root.darkGray
    readonly property alias value: root.black
    readonly property alias frame: root.mediumGray
    readonly property alias disable: root.lightGray1

    // Keyboard
    readonly property alias specialButton: root.mediumGray
    readonly property alias keyButton: root.white
    readonly property alias buttonPressed: root.lightBlue
    readonly property alias keyboardBackground: root.lightGray2

    /// @brief Change alpha value of the color
    /// @param[in] color Color to change
    /// @param[in] alpha New alpha value (0 transparent, 1 opaque)
    /// @return color with new alpha value
    function changeTransparent(color, alpha){
        return Qt.rgba(color.r, color.g, color.b, alpha)
    }
}
