'''Module that syncs path for incoming CDM files
'''
import os

from .file_sync import get_usc_proxy_object

USC_SERVICE = "com.jdsu.usc"
USC_PATH = "/Usc"

CDM_DOWNSTREAM_FILEPATH = '/tmp/cdm'
CDM_DOWNSTREAM_TEMPLATES_PATH = '/tmp/workflow' #  **already provided to USC by ISU but also needed here**

def register_cdm_filepath():
    """
    Registers the directory for incoming files from Stratasync

    """
    proxy_object = get_usc_proxy_object()
    if proxy_object:
        if not os.path.exists(CDM_DOWNSTREAM_FILEPATH):
            os.makedirs(CDM_DOWNSTREAM_FILEPATH)
        proxy_object.Register_Root_Path(CDM_DOWNSTREAM_FILEPATH)

        if not os.path.exists(CDM_DOWNSTREAM_TEMPLATES_PATH):
            os.makedirs(CDM_DOWNSTREAM_TEMPLATES_PATH)
        proxy_object.Register_Root_Path(CDM_DOWNSTREAM_TEMPLATES_PATH)
