"""Module that deals with decoupling the rest_api web application from
from functions that need to be injected into it to deal with product specific
actions
"""
import importlib


PRODUCT_STR_TO_MODULE_STR = {
    'T-BERD 5800 V2': 'products.mts_5800',
    'MTS 5800 V2': 'products.mts_5800',
    'MTS 5882': 'products.mts_5800',
    'T-BERD 5882': 'products.mts_5800',
    'T-BERD 5800-100G': 'products.mts_5800',
    'MTS 5800-100G': 'products.mts_5800',
    'SC 4800': 'products.metro_base',
    'SC 4800P': 'products.metro_base',
    'MAP-2100': 'products.metro_base',
    'fiberMts': 'products.fiber_base', # RestAPI baseline for MTS4kv2, MTS2kv2 and SmartOTDR
    'fiberJobMgr': 'products.fiber_mts_jobmgr', # fiber_base with JobMgr support on top
    'ONA-800': 'products.ona_800',
    'ONA-1000': 'products.ona_800',
    'CA5000': 'products.ona_ca5g',
    'off-target': 'products.product_specific_base'
}

def product_specific(product_str):
    """Function to determine application configuration values based on the
    name of the product

    Args:
        product_module_str (str): the name of the python module containing
            configuration for the product.  This module must have a `config`
            callable that will return a dictionary of configs that need to
            be changed from defaults
    """
    product_module_str = PRODUCT_STR_TO_MODULE_STR.get(product_str)
    product = importlib.import_module('rest_api.{}'.format(product_module_str))

    return product.ProductSpecific
