"""
Module handles sending location info to
appropriate service to update the instrument location
"""

import threading
import subprocess
import tarfile, io
import json
import dbus
import os

from bottle import request, response, Bottle

app = Bottle()  # pylint: disable=invalid-name


#class UploadArgs(Schema):
#    """Schema class for the userfiles POST Endpoint
#    """
#    filedata = fields.Field(
#        required=True,
#        description='The file to upload'
#    )


def MountRamDisk():
    sNomRamDisk = '/mnt/tmp'
    subprocess.run(["umount", sNomRamDisk], stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)

    try:
        subprocess.check_output(["mount", "-t", "tmpfs", "-o", "size=512M", "tmpfs", sNomRamDisk])
    except CalledProcessError:
        sNomRamDisk = ''

    return sNomRamDisk


#def get_FS_partition_number_list():
#    mmc = list(get_block_devices("MMC").keys())[0]

#    partition_table = get_partition_plan()
#    TabPartId = []
#    for partid in range(len(partition_table)):
#        part = partition_table[partid]
#        if 'label' in part.keys() and not part['protected'] and 'FS' in part['label']:
#            # ex : mkfs.ext4 -F -L FS1 /dev/mmcblk0p5
#            print("mkfs.%s -F -L %s %s" % (part['format'], part['label'], "/dev/%sp%i" % (mmc, partid + 1)))
#            PartInfo = []
#            PartInfo.append(partid + 1)
#            PartInfo.append("/dev/%sp%i" % (mmc, PartInfo[0]))
#            TabPartId.append(PartInfo)

#    return TabPartId


#def MountMmcTmpPart():
#    bOK = False
#    TabPartId = get_FS_partition_number_list()

#    bootenv.refresh()
#    mmc_part = int(bootenv.mmc_part)
#    print('mmc_part {}'.format(mmc_part))

#    nNewPart = -1

#    if (len(TabPartId) == 2):
#        if (mmc_part == TabPartId[0][0]):
#            nNewPart = 1
#        else:
#            nNewPart = 0


#        sPartitionName = TabPartId[nNewPart][1]

#        print('sPartitionName {}'.format(sPartitionName))

#        # Testé OK : subprocess.check_output(["mkfs.ext4", "-F", sPartitionName])

#        sync()

#        mount(sPartitionName, '/mnt/nfs', 'ext4')

#        bOK = True

#    return bOK

#def ArchiveToRamDisk(sArchive, sRamDisk):
#    print('ArchiveToRamDisk {0} -- {1}'.format(sArchive, sRamDisk))
#    return(True)


def ToRunLevel4():
    print('ToRunLevel4')
    subprocess.check_output(['init', '4'])
    subprocess.check_output(['sleep', '5'])


def LanceUpgrade(sCheminXml):
    bErrorCode = True

    sCheminXml = '0:' + sCheminXml
    bus=dbus.SystemBus()
    proxy = bus.get_object('com.viavi.releasemanager', "/com/viavi/releasemanager")
    sma = dbus.Interface(proxy, dbus_interface='com.viavi.releasemanager')

    try:
        sma.set_ack_upgrade_timout(0)
    except:
        pass

    try:
        print('LanceUpgrade {0}'.format(sCheminXml))
        print(sma.start_upgrade(sCheminXml))

    except :
        print('LanceUpgrade Error')
        bErrorCode = False

    return bErrorCode


sDeployTimeFile = '/var/db/fwDeployTime.json'
sDeployTimeFileFuture = '/mnt/fs/var/db/fwDeployTime.json'
gsFirmwareEtat = 'noUpgrade' #['upgradeAvailable', 'downloading', 'applying']
gnFirmwareCompteur = 0
gnDeployTimeValue = 0
gbDeployTimeFileFutureCreated = False


def getDeployTimeValue():
    global gnDeployTimeValue
    return(gnDeployTimeValue)


def reset_firmware_upgrade_status():
    global gnDeployTimeValue
    global gsFirmwareEtat
    global gnFirmwareCompteur

    #print('reset_firmware_upgrade_status')
    gsFirmwareEtat = 'noUpgrade'
    gnFirmwareCompteur = 0

    nValeur = 0
    try:
        with open(sDeployTimeFile, 'r') as json_input:
            Value = json.load(json_input)
            #print('Value = {0}'.format(Value))
            gnDeployTimeValue = Value['fwDeployTime']
            print('fwDeployTime = {0}'.format(gnDeployTimeValue))

            # file used only once
            remove_DeployTimeFile()
    except:
        gnDeployTimeValue = 0



def process_firmware_upgrade_status():
    global gnFirmwareCompteur
    global gsFirmwareEtat
    global gnDeployTimeValue
    global gbDeployTimeFileFutureCreated

    bus=dbus.SystemBus()
    proxy = bus.get_object('com.viavi.releasemanager', "/com/viavi/releasemanager")
    sma = dbus.Interface(proxy, dbus_interface='com.viavi.releasemanager')


    sLastUpgradestate = sma.get_last_upgrade_state()
    nProgress = sma.get_progress()


    print('sLastUpgradestate {0} - {1}%'.format(sLastUpgradestate, nProgress))

    if (sLastUpgradestate == 'UPGRADING'):
        # normalement deja positionne
        gsFirmwareEtat = 'applying'
        gnFirmwareCompteur = nProgress

        if (gbDeployTimeFileFutureCreated == False):
            if (gnDeployTimeValue != 0):
                try:
                    with open(sDeployTimeFileFuture, 'w') as json_output:
                        json_output.write(json.dumps({'fwDeployTime':gnDeployTimeValue}))
                    gbDeployTimeFileFutureCreated = True
                    print('gbDeployTimeFileFutureCreated {0}'.format(gbDeployTimeFileFutureCreated))
                except:
                    pass
    else:
        if ((sLastUpgradestate == 'PASS') and (gsFirmwareEtat == 'applying')):
            gsFirmwareEtat = 'applyComplete'
            gnFirmwareCompteur = 100
        else:
            if ((sLastUpgradestate == 'PASS') and (gsFirmwareEtat == 'applyComplete')):
                gsFirmwareEtat = 'rebooting'
                gnFirmwareCompteur = 100
            else:
                if (sLastUpgradestate == 'PASS'):
                    gsFirmwareEtat = 'rebooting'
                    gnFirmwareCompteur = 100
                    subprocess.call(["reboot"])
                else:
                    if (sLastUpgradestate == 'FAIL'):
                        gsFirmwareEtat = 'applyFailed'
                        gnFirmwareCompteur = 100



    print('gsFirmwareEtat = {0}'.format(gsFirmwareEtat))
    FirmwareStatus = {
        'features': [
            "mobile-download"
            ],
        'hasNetworkAccess': False,
        'hasPower': True,
        'upgradeStatus': gsFirmwareEtat,
        'progress': gnFirmwareCompteur,
        'availableVersion': "20.0"
        #'images': [
        #    {
        #        'name': "release.xml"
        #    }
        #]
    }


    return FirmwareStatus


def remove_DeployTimeFile():
    try:
        os.remove(sDeployTimeFile)
    except:
        pass


def process_firmware_upgrade_put(request):
    #print('Debug process_firmware_upgrade_put Enter')

    global gnDeployTimeValue
    global gsFirmwareEtat
    global gbDeployTimeFileFutureCreated

    gsFirmwareEtat = 'waiting'
    gbDeployTimeFileFutureCreated = False


    remove_DeployTimeFile()

    try:
        requete = request.body.getvalue()

        Value = json.loads(requete.decode('ascii'))
        gnDeployTimeValue = Value['artifact']['fwDeployTime']

        print('gnDeployTimeValue = [{0}]'.format(gnDeployTimeValue))

    except:
        gnDeployTimeValue = 0

    success = True

    #print('Debug process_firmware_upgrade_put Leave')

    return success


def process_firmware_upgrade_post(request, Filename):
    """

    Returns:
        True if the request was ack'd
    """

    global gsFirmwareEtat

    gsFirmwareEtat = 'preparing'

    success = False
    sErrorCode = 'Done'

    print('Debug process_firmware_upgrade_post Enter')

    class Myfileobj(io.FileIO):


        def __init__(self, length):
            #self.WAIT_SECONDS = 10
            #self.timer = threading.Timer(self.WAIT_SECONDS, self.myTimer)
            #self.timer.start()
            self.headers = True
            self.length = length
            self.nMemoLength = length
            self.raw = request.environ['wsgi.input']

        def myTimer(self):
            gsFirmwareEtat = 'downloadFailed'
            print('TIME OUT sur Read')
            #self.raw.close()


        def read(self, size):
            seq = [b'\r', b'\n', b'\r', b'\n']
            seqn = 0
            # Fast Forward to content
            while self.headers:
                a = request.environ['wsgi.input'].read(1)
                self.length -= 1
                if a == seq[seqn]:
                    seqn += 1
                else:
                    seqn = 0
                if seqn == len(seq):
                    self.headers = False
            s = min(size, self.length)
            d = request.environ['wsgi.input'].read(s)
            self.length -= s

            #self.timer.cancel()
            #self.timer = threading.Timer(self.WAIT_SECONDS, self.myTimer)
            #self.timer.start()

            return d


    #product_specific = app.config['rest_api.product_specific']



    sRamDisk = MountRamDisk()
    if (sRamDisk == ''):
        sErrorCode = 'MountRamDisk failed'
        gsFirmwareEtat = 'noStorage'

    sUpgradeDir = sRamDisk + '/upload'


    #ToRunLevel4()


    if (sErrorCode == 'Done'):
        gsFirmwareEtat = 'downloading'
        wrapper = Myfileobj(request.content_length)
        zip = tarfile.open(fileobj=wrapper, mode="r|*")
        try:
            zip.extractall(sUpgradeDir)
        except tarfile.TarError:
            gsFirmwareEtat = 'downloadFailed'
            sErrorCode = 'TarError'


    if (sErrorCode == 'Done'):
        gsFirmwareEtat = 'applying'
        gnFirmwareCompteur = 0
        sUpgradefile = sUpgradeDir + '/release.xml'

        if (LanceUpgrade(sUpgradefile) == False):
            gsFirmwareEtat = 'applyFailed'
            sErrorCode = 'LanceUpgrade failed'

    if (sErrorCode == 'Done'):
        success = True


    #print('Debug process_firmware_upgrade_post Leave')

    return success
