"""Module defining the AccessAnywhere namedtuple
YAML below is used to generate swagger
---
connectStatus:
    type: boolean
    description: >-
        the status of the access anywhere connection true if connected false
        otherwise
accessCode:
    type: string
    description: >-
        access anywhere code returned from server will be null if the
        connection is unsuccessful
    x-nullable: true
hasIpAddress:
    type: boolean
    description: >-
        the status of the internet connection on the instrument - can be used
        to propmt the user to establish an IP connection before trying again
errorMessage:
    type: string
    description: a user readable error message that can be displayed
"""
import collections

AccessAnywhere = collections.namedtuple(
    'access_anywhere',
    field_names=[
        'connectStatus',
        'accessCode',
        'hasIpAddress',
        'errorMessage',
    ]
)
