# -*- coding: utf-8 -*-

"""
Module contains functionaikty for creating reports in different languages

get_report_strings is the function to generate language specific strings
"""
# Another spot with some translations... not all languages are present for STE MTS
# beware locale differences for STE
REPORT_STRINGS_LANGUAGES = {'en': {'technician_id': 'Technician ID',
                                   'test_location': 'Test Location A',
                                   'test_location_b': 'Test Location B',
                                   'cable_id': 'Cable ID',
                                   'contractor_id': 'Contractor ID',
                                   'job_comments': 'Comments',
                                   'job_number': 'Work Order',
                                   'customer_name': 'Customer Name',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   'Generated by Viavi Test Instrument'},

                            'de': {'technician_id': 'Techniker-ID',
                                   'test_location': 'Ort des Tests',
                                   'job_number': 'Arbeitsauftrag',
                                   'customer_name': 'Name des Kunden',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   'Erstellt von dem Viavi-Prüfgerät'},

                            'es': {'technician_id': 'ID del técnico',
                                   'test_location': 'Ubicación de la Prueba',
                                   'job_number': 'Orden de trabajo',
                                   'customer_name': 'Nombre del Cliente',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   'Generado por Viavi Test Instrument'},

                            'fr': {'technician_id': 'ID du technicien',
                                   'test_location': 'Localisation du Test',
                                   'job_number': 'Commande de travail',
                                   'customer_name': 'Nom du client',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   "Généré par l'instrument de test de Viavi "},

                            'zh': {'technician_id': '技术员 ID',
                                   'test_location': '测试地点',
                                   'job_number': '工作顺序r',
                                   'customer_name': '用户名',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   '由 Viavi 测试仪器生成'},

                            'it': {'technician_id': 'ID Tecnico',
                                   'test_location': 'Posizione del test',
                                   'job_number': 'Ordine di lavoro',
                                   'customer_name': 'Nome cliente',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   'Generato da strumento di prova Viavi'},

                            'ja': {'technician_id': '技術者 ID',
                                   'test_location': 'ﾃｽﾄ ﾛｹｰｼｮﾝ',
                                   'job_number': '作業指示書',
                                   'customer_name': '顧客名',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   'Generated by Viavi Test Instrument'},

                            'ko': {'technician_id': '기술자 ID',
                                   'test_location': '테스트 위치',
                                   'job_number': '작업 순서',
                                   'customer_name': '고객 이름',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   'Viavi 테스트 장치가 생성함'},

                            'pt': {'technician_id': 'ID de Técnico',
                                   'test_location': 'Local do teste',
                                   'job_number': 'Ordem de Serviço',
                                   'customer_name': 'Nome do cliente',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   'Gerado pelo instrumento de teste da Viavi'},

                            'ru': {'technician_id': 'ID- Техник',
                                   'test_location': 'Местоположение испытания',
                                   'job_number': 'Заказ на выполнение работ',
                                   'customer_name': 'Имя абонента',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   'Создано средством для проведения испытаний компании Viavi'},

                            'tr': {'technician_id': 'Teknisyen ID',
                                   'test_location': 'Test Location',
                                   'job_number': 'Work Order',
                                   'customer_name': 'Customer Name',
                                   'Test Type': 'Test Type',
                                   'File Path': 'File Path',
                                   'Verdict': 'Verdict',
                                   'Reference Info': 'Reference Info',
                                   'Summary Report': 'Summary Report',
                                   'Generated by Viavi Test Instrument':
                                   'Generated by Viavi Test Instrument'}}

def get_report_strings(env_language):
    """
    Function to generate the report strings for a given language

    Args:
        env_language (str): the current language for the system

    Returns:
        report_strings (dict): dictionary containing strings for the report
    """
    language_key = env_language[0:2]
    report_strings = REPORT_STRINGS_LANGUAGES.get(language_key)
    return report_strings
