"""
Module containing endpoints for the Smart Access Anywhere API
"""
from bottle import Bottle, response, request


app = Bottle()  #pylint: disable=invalid-name

@app.put('/api/saa/v1/accesscode')
def access_anywhere_code():
    """
    Endpoint to connect instrument to smart access anywhere
    service
    ---
    put:
        tags:
          - access anywhere
        description: tells instrument to attempt connection to access anywhere server
        responses:
            201:
                description: Success an access anywhere code has been created
                schema:
                    $ref: '#/definitions/AccessAnywhere'
            503:
                description: >-
                    Failure an access anywhere code has not been created
                schema:
                    $ref: '#/definitions/AccessAnywhere'
    """
    request.body.read() #pylint: disable=no-member
    product_specific = app.config['rest_api.product_specific']
    access_anywhere = product_specific.get_access_anywhere_code('127.0.0.1')
    if access_anywhere.connectStatus:
        response.status = 201
    else:
        response.status = 503

    return access_anywhere._asdict()
