#!/bin/sh

#disable globbing
set -f
RESULT=0
ROOT_ACCESS="$(fw_printenv root_access | cut -f2 -d= )"

# force smartotu login
/usr/lib/jdsu/scripts/change_smartotu_login.sh admin
RESULT=$(($RESULT+$?))

# force smartotu password
/usr/lib/jdsu/scripts/change_smartotu_password.sh password
RESULT=$(($RESULT+$?))

# force root password
if [ "$CFG_PLATFORM_NAME" == "Otu8kv2" ];
then
   usermod -p '$1$Koibdpp5$.pMQKYhmvP1DDWK6XAG1I/' root
else
   usermod -p '$6$mSLmJ/5CvGelNR$IY/xRS8sO2n.Ok3RXL7rr./pWmyQyOPmVs.Ei93KgDstbxjBi.5aFsJwfM9Rt/nnpthDUAMcpc/dAjxyXFv4h/' root
fi
RESULT=$(($RESULT+$?))

# force secuser password
if [[ "${ROOT_ACCESS}" != "true" ]] ; then
   if [ "$CFG_PLATFORM_NAME" == "Otu8kv2" ];
   then
       echo secuser:8s0e0c0 | chpasswd
   else
       echo secuser:5s0e0c0 | chpasswd
   fi
   RESULT=$(($RESULT+$?))
fi

echo "result: $RESULT"
exit $RESULT

