#!/bin/bash
#  trace de l'empreinte memoire d'applications
# tous les parametres sont optionnels (== otu_memtest.sh ALL "/otu/log/otu-mem.log" 5)
# lancement : otu_memtest.sh [APPL] [LOGFILE] [DELAY]

PIDF="/tmp/otu_memtest.pid"
APPL='Otu|Isu|Fiber_Optic|X'
W=$((5 * 60))
F="/otu/log/otu-memtrace.log"

# fichier de log
[ "$1" != "" ] && F="$1"

# delay entre deux tests d'empreinte memoire
[ "$2" != "" ] && W=$(( $2 * 60 ))

#echo "TEST t=${W}, f=${F}, A=${APPL}"

if [ "$W" == "0" ]
then
   # one shot
   # echo "ONE SHOT"
   date>>"${F}"
   /usr/lib/jdsu/scripts/ps_mem.py | grep -E "${APPL}">>${F}
else
   # boucle infinie
   # echo "DETACH"
   COMMAND="date>>\"${F}\";/usr/lib/jdsu/scripts/ps_mem.py | grep -E \"${APPL}\">>\"${F}\""
   watch -t -n $W "${COMMAND}" &
   # PID pas dans /var/run
   echo $! > $PIDF
fi

exit 0
