#!/bin/bash
#set -x

function GetFreePort
   {
   local Port

   read LowerPort UpperPort </proc/sys/net/ipv4/ip_local_port_range
   NbPorts=$(( UpperPort - LowerPort + 1 ))

   while [ "$Port" == "" ]
      do
      Port=$(( $RANDOM % NbPorts + LowerPort ))
      ss -nl | grep :$Port 2>&1 >/dev/null
      if [ $? == 0 ]
         #Port deja utilise, on en essaye un autre
         then
         Port=
         fi
      done

   eval $1=$Port
   }

function Authentication
   {
   local media ProxyPac UseProxy RetCode RetCode_22 RetCode_443 RetCode_443_Proxy time_22 time_443 time_443_proxy

   #Savoir par quel media on passe
   Media=$(route | grep default | head -n1 | awk '{print $8}' | sed "s/[0-9]//g")

   ProxyPac=""
   ViaProxy=""

   #Obtenir la configuration du Proxy dans System Setup sauf dans le cas usb o ce n'est pas utile (connexion directe internet 3G)
   if [ "$media" != "usbg" ]
      then
      UseProxy=$(echo "*rem;SYST:PROXY:USE?" | nc -w2 127.0.0.1 8000)
      
      case $UseProxy in
         MAN)
            Proxy=$(echo "*rem;SYST:PROXY:ADDR?" | nc -w2 127.0.0.1 8000)
            if [ "$Proxy" != "" ]
               then
               ViaProxy="-p $Proxy"
            fi
            ;;
         
         PAC)
            ProxyPac=$(echo "*rem;SYST:PROXY:PAC?" | nc -w2 127.0.0.1 8000)
            if [ "$ProxyPac" != "" ]
               then
               Proxy=$(get_proxy_from_pac $ProxyPac $SP_SSH1 $SP_SSH1 | cut -f2 -d "=")
               if [ "$Proxy" != "" ]
                  then
                  ViaProxy="-p $Proxy"
               fi
            fi
            ;;
         
         *)  ;;
      esac
   fi

   # On teste les 3 "chemins" possibles ( port 22 direct, port 443 direct et port 443 via proxy) pour choisir le plus "efficace"
   # temps en 1/100 de seconde
   set -o pipefail
   time_22=$(/usr/bin/time 2>&1 -p $ssh -i /root/.ssh/kpriv_pc -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 22 AskConnectionPC CODE LIN_15.09.11 $Magic_Number ds.jdsu.net >$basedir/param_pc_22  | tail -n 3 | head -n 1 | awk '{print $2}' | sed 's/^0*\([0-9]*\)\.\([0-9]*\)/\1\2/')
   RetCode_22=$?
   
   time_443=$(/usr/bin/time 2>&1 -p $ssh -i /root/.ssh/kpriv_pc -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionPC CODE LIN_15.09.11 $Magic_Number ds.jdsu.net >$basedir/param_pc_443  | tail -n 3 |  head -n 1 | awk '{print $2}' | sed 's/^0*\([0-9]*\)\.\([0-9]*\)/\1\2/')
   RetCode_443=$?
   
   if [ "$ViaProxy" != "" ]
      then
      time_443_proxy=$(/usr/bin/time 2>&1 -p $ssh -fN -i /root/.ssh/kpriv_pc -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Authentication@$SP_SSH1 -p 443 AskConnectionPC CODE LIN_15.09.11 $Magic_Number ds.jdsu.net >$basedir/param_pc_443_proxy  | tail -n 3 |  head -n 1 | awk '{print $2}' | sed 's/^0*\([0-9]*\)\.\([0-9]*\)/\1\2/')
      RetCode_443_Proxy=$?
   else
      time_443_proxy=9999
      RetCode_443_Proxy=255
   fi
   set +o pipefail
   
   # On choisit le chemin le plus rapide parmi ceux ayant aboutis
   Chemin=$(echo -e "$RetCode_22 $time_22 P22\n$RetCode_443 $time_443 P443\n$RetCode_443_Proxy $time_443_proxy P443P" | grep '^0' | cut -f2-3 -d ' ' | sort -n | head -n 1 | awk '{print $2}')
   
   case $Chemin in
      P22)
         RetCode=$RetCode_22
         PortUsed=22
         ViaProxy=
         cp -f $basedir/param_pc_22 $basedir/param_pc
         ;;
      
      P443)
         RetCode=$RetCode_443
         PortUsed=443
         ViaProxy=
         cp -f $basedir/param_pc_443 $basedir/param_pc
         ;;
         
      P443P)
         RetCode=$RetCode_443_Proxy
         PortUsed=443
         cp -f $basedir/param_pc_443_proxy $basedir/param_pc
         ;;
      
      *)
         RetCode=255
         ;;
   esac

   if [ "$RetCode" == 0 ]
      then
      chmod 400 $basedir/param_pc

      #Extraction des ports a forwarder "Remote"
      ChampPort=2
      PortSrc=$(cat $basedir/param_pc  | grep cnx_device_port_local_forwarded_destination | awk -F "[:,]" '{print $'$ChampPort'}')
      PortDst=$(cat $basedir/param_pc  | grep cnx_device_port_local_forwarded_origine | awk -F "[:,]" '{print $'$ChampPort'}')
      while [ "$PortDst" != "" ]
         do
         RemoteForwardPorts="$RemoteForwardPorts -R$PortSrc:localhost:$PortDst"
         ((ChampPort++))
         PortSrc=$(cat $basedir/param_pc  | grep cnx_device_port_local_forwarded_destination | awk -F "[:,]" '{print $'$ChampPort'}')
         PortDst=$(cat $basedir/param_pc  | grep cnx_device_port_local_forwarded_origine | awk -F "[:,]" '{print $'$ChampPort'}')
         done

      #Extraction des ports a forwarder "Local"
      ChampPort=2
      PortAssignation=$(cat $basedir/param_pc  | grep cnx_device_port_remote_forwarded_assignation | awk -F "[:,]" '{print $'$ChampPort'}')
      GetFreePort PortSrc
      PortDst=$(cat $basedir/param_pc  | grep cnx_device_port_remote_forwarded_origine | awk -F "[:,]" '{print $'$ChampPort'}')
      if [ "$PortAssignation" == "SSH" ]
         then
         PortSsh=$PortSrc
         DestSsh=$PortDst
      fi
      while [ "$PortDst" != "" ]
         do
         LocalForwardPorts="$LocalForwardPorts -L$PortSrc:localhost:$PortDst"
         echo $PortAssignation:$PortSrc
         ((ChampPort++))
         PortAssignation=$(cat $basedir/param_pc  | grep cnx_device_port_remote_forwarded_assignation | awk -F "[:,]" '{print $'$ChampPort'}')
         GetFreePort PortSrc
         PortDst=$(cat $basedir/param_pc  | grep cnx_device_port_remote_forwarded_origine | awk -F "[:,]" '{print $'$ChampPort'}')
         if [ "$PortAssignation" == "SSH" ]
            then
            PortSsh=$PortSrc
            DestSsh=$PortDst
         fi
         done

      echo -n $PortSsh > /tmp/anywhere.port

      #Extraction de l'adresse IP du serveur o?=|  utiliser
      ServerIp=$(cat $basedir/param_pc  | grep cnx_server_ip | cut -d ":" -f 2)
   
      #Dans le cas config automatique du proxy avec un fichier .pac, il faut rechercher le proxy avec
      #cette nouvelle adresse IP si on a dcid de passer par le proxy
      if [ "$ViaProxy" != "" -a "$ProxyPac" != "" ]
         then
         Proxy=$(get_proxy_from_pac $ProxyPac $ServerIp $ServerIp | cut -f2 -d "=")
         if [ "$Proxy" != "" ]
            then
            ViaProxy="-p $Proxy"
         else
            ViaProxy=""
         fi
      fi
   fi

   return $RetCode
   }

SP_SSH1='mtsanywhere.updatemyunit.net' #OVH

#source /etc/platform.conf

PATH=/usr/local/sbin:/usr/local/bin:$PATH:/usr/lib/busybox/bin:/sbin

basedir=$(dirname $0)

Magic_Number=$2

Connection_Type=$1
# CONNECT, CONNECT_IP, DISCONNECT


# if "ssh-weak" not found, try "ssh"
ssh=ssh-weak
if ! type -p $ssh >/dev/null 2>&1; then
  ssh=ssh
fi

#pour discriminer la faon dont est gr le rpertoire /user
if [ ! -d /user/.media ]
   then
   NewUserPolicy=true
fi

if [ "$Connection_Type" != "DISCONNECT" ]
   then
   if [ "$Connection_Type" = "CONNECT_IP" ]
      then
      GetFreePort PortSsh
      echo SSH:$PortSsh
      echo -n $PortSsh > /tmp/anywhere.port

      GetFreePort PortVnc
      echo VNC:$PortVnc

      Param_Grep=ssh.*sma
      Anywhere_Or_Ip_File=/tmp/m2m.ip
      RetCode=0
   else
      Param_Grep=ssh.*param_pc.*MAW_Connection
      Anywhere_Or_Ip_File=/tmp/anywhere.nbr
      Authentication
      RetCode=$?
   fi
   echo $Param_Grep >/tmp/Param_Grep_Client_Connection_Script

   if [ "$RetCode" == 0 ]
      then
      # Si il i y a deja une connexion active il ne faut pas en lancer une deuxieme, il faut par contre tuer un ventuel "zombie"
      MAW_Connection=$(ps aux | grep $Param_Grep | grep -v 'sshd\|grep')
      if [ "$MAW_Connection" != "" ]
         then
         IsGoodPortSsh=$(echo $MAW_Connection | grep $DestSsh)
         if [ "$IsGoodPortSsh" == "" ]
            then
            kill $(ps aux | grep $Param_Grep | grep -v 'sshd\|grep' | tr -s " " | cut -d " " -f 2)
            MAW_Connection=$(ps aux | grep $Param_Grep | grep -v 'sshd\|grep')
         fi
      fi

      if [ "$MAW_Connection" == "" ]
         then
         if [ "$Connection_Type" = "CONNECT_IP" ]
            then
            # connexion ssh sur le MTS
            $ssh -fN -i /home/sma/.ssh/sma_rsa -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null  -L $PortSsh:localhost:22 -L $PortVnc:localhost:5900 sma@$Magic_Number
            else
            # connexion ssh sur le serveur smartaccessanywhere
            $ssh -fN -i $basedir/param_pc -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null  -o "ProxyCommand=$basedir/ssh-proxy.sh -s $ssh $ViaProxy %h %p" MAW_Connection@$ServerIp $RemoteForwardPorts $LocalForwardPorts -p $PortUsed
         fi
      fi
      RetCode=$?

      if [ "$RetCode" == 0 ]
         then
         # connexion ssh sur l'appareil "esclave"
         $ssh -fN local -o UserKnownHostsFile=/dev/null -L18000:localhost:8000 -L18001:localhost:8001 -L18002:localhost:8002 -L18003:localhost:8003  \
                        -L18004:localhost:8004 -L18005:localhost:8005 -L18006:localhost:8006 -L18007:localhost:8007 -p $PortSsh
         RetCode=$?
         if [ "$RetCode" == 0 ]
            then
            #test si SAA est dmarr explicitement sur la base distante
            StatusSAA=$(echo "*rem;SYST:SAA?" | nc -w2 127.0.0.1 18000  | tr -d " ")
            #test la licence valide sur la base distante
            M2mLinkLicence=$(echo "*rem;PROC:LIC:STAT? \"Anywhere\",\"SMART_ACCESS_L2\"" | nc -w2 127.0.0.1 18000  | tr -d " ")
            if [ "$Connection_Type" != "CONNECT_IP" -a "$StatusSAA" == "DISCONNECTED" ]
               then
               RetCode=255
               echo -en "*rem\nprocess:warning \"\",\"Please activate SmartAccesAnywhere on distant unit\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
            elif [ "VALID" != "$M2mLinkLicence" ]
               then
               RetCode=255
               echo -en "*rem\nprocess:warning \"\",\"No license present on distant unit\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
            else
               # montage sshfs disques distants
               ssh oeo@local -p $PortSsh 'test -d /acterna/user/harddisk'
               if [ $? == 0 ]
               then
                  mkdir /tmp/slaveharddisk
                  sshfs oeo@local:/acterna/user/harddisk /tmp/slaveharddisk/ -C -o nonempty -o allow_other -p $PortSsh
                  if [ "$?" != 0 ]
                     then
                     rmdir /tmp/slaveharddisk
                  else
                     if [ -n "$NewUserPolicy" ]
                        then
                        ln -fs /acterna/user/slaveharddisk /user/slaveharddisk
                     fi
                  fi
               else
                  mkdir /tmp/slavedisk
                  sshfs oeo@local:/acterna/user/disk /tmp/slavedisk/ -C -o nonempty -o allow_other -p $PortSsh
                  if [ "$?" != 0 ]
                     then
                     rmdir /tmp/slavedisk
                  else
                     if [ -n "$NewUserPolicy" ]
                        then
                        ln -fs /acterna/user/slavedisk /user/slavedisk
                     fi
                  fi
               fi
               
               if [ -e /usr/lib/jdsu/scripts/Generate_Auto_User.sh ]
                  then
                  /usr/lib/jdsu/scripts/Generate_Auto_User.sh
               fi
               
               #surveille la connexion entre les deux bases si elle tombe sur le distant , on eteint la base local
               Ssh_Pid=$(ps ax | grep ssh | grep "local " | grep  $PortSsh | grep -v oeo |  head -n 1 | awk '{ print $1 }')
               if [ "$Ssh_Pid" != "" ]
                  then
                  ( (
                  while [ -d /proc/$Ssh_Pid ]
                     do
                        sleep 10
                        done
                        echo  "*rem;ISU:M2MLINK OFF"  | nc -w2 127.0.0.1 8000	    
                  ) &)&
               fi
               #activation du datalink sur l'appareil "esclave"
               if [ ! -f /tmp/anywhere_remote.nbr ]
                  then
                  # transmission du magic number
                  scp -P $PortSsh $Anywhere_Or_Ip_File local:/tmp/anywhere_remote.nbr
                  echo "*rem;mod:func:sel boths,base,\"M2MLINK\",on" | nc -w2 127.0.0.1 18000
               fi
               # lecture identite de l'appareil esclave
               MtsIdent=$(echo "*rem;*idn?" | nc -w2 127.0.0.1 18000  | tr -d " " )
               MtsName=$(echo $MtsIdent | cut -d ',' -f2)
               MtsSN=$(echo $MtsIdent | cut -d ',' -f3)
               echo -en "*rem\nprocess:warning \"\",\"Connected to $MtsName S/N $MtsSN\", INFO, 0,\"\",\"\",\"Press any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
            fi
         else
            # le lien MTS distant avec le serveur SAA est rompu
            # ou impossible d'tablir la connection ssh a l'interieur du premier tunnel
            kill $(ps aux | grep $Param_Grep | grep -v 'sshd\|grep' | tr -s " " | cut -d " " -f 2)
            if [ "$Connection_Type" = "CONNECT_IP" ]
               then
            echo -en "*rem\nprocess:warning \"\",\"Unable to connect to distant unit IP address $2\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
               else
               echo -en "*rem\nprocess:warning \"\",\"Connection for Access Code $2 is broken between device and SmartAccessAnywhere server\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
            fi

         fi
      else
         # affichage warning indiquant echec connexion
         if [ "$Connection_Type" = "CONNECT" ]
            then
            grep JDSU_Error $basedir/param_pc
            if [ "$?" = 0 ]
               then 
               Warn=$(cat $basedir/param_pc | tr '\n' ':' | cut -d ':' -f4)
            else
               Warn="Connection failed"
            fi
            echo -en "*rem\nprocess:warning \"\",\"$Warn\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
         else
            echo -en "*rem\nprocess:warning \"\",\"Unable to connect to distant unit IP address $2\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
         fi
      fi   
   else
      # affichage warning indiquant echec connexion d'authentification
      echo -en "*rem\nprocess:warning \"\",\"Connection failed\", ERROR, 0,\"\",\"\",\"Hit any key to continue\"\n" >/dev/tcp/127.0.0.1/8000
   fi
   echo RETCODE:$RetCode
else
   #deconnexion
   #arret du processus detach qui surveille la connexion entre deux bases quand elle tombe.
   kill $(ps aux | grep client_connection_script | grep -v grep | grep -v $$ | tr -s ' ' | cut -d ' ' -f2 )
   # arret du datalink sur l'appareil "esclave"
   echo "*rem;ISU:M2MLINK OFF" | nc -w2 127.0.0.1 18000
     
   fusermount -u -z /tmp/slaveharddisk
   fusermount -u -z /tmp/slavedisk
   if [ -n "$NewUserPolicy" ]
      then
      fusermount -u -z /acterna/user/slaveharddisk
      fusermount -u -z /acterna/user/slavedisk
      else
      fusermount -u -z /user/.media/slaveharddisk
      fusermount -u -z /user/.media/slavedisk
   fi

   read Param_Grep </tmp/Param_Grep_Client_Connection_Script
   kill $(ps aux | grep $Param_Grep | grep -v 'sshd\|grep' | tr -s " " | cut -d " " -f 2)
   sshid=$(ps aux | grep ssh | grep -v grep | grep slave | tr -s ' ' | cut -d ' ' -f2)
   while  [ "$sshid" != "" ]
      do
      kill -9 $sshid
      sshid=$(ps aux | grep ssh | grep -v grep | grep slave | tr -s ' ' | cut -d ' ' -f2)
   done

   rmdir /tmp/slavedisk
   rmdir /tmp/slaveharddisk

   if [ -n "$NewUserPolicy" ]
      then
      rm -f /user/slavedisk /user/slaveharddisk
   fi

   if [ -e /usr/lib/jdsu/scripts/Generate_Auto_User.sh ]
      then
      /usr/lib/jdsu/scripts/Generate_Auto_User.sh
   fi
   
( (
   # on attend deux secondes de plus que le timeout de l'automount
   sleep $(($(cat /etc/auto.master | grep misc | grep -v "#" | cut -d '=' -f2) + 2))

   if [ -n "$NewUserPolicy" ]
      then
      umount -f /acterna/user/slaveharddisk
      umount -f /acterna/user/slavedisk
      else
      umount -f /user/.media/slavedisk
      umount -f /user/.media/slaveharddisk
   fi
 ) & ) &
fi
