#!/bin/bash
# Create ssh connection and local port forwarding for otu to topaz server dialog
# returned value : 0 if OK, else 1

#set -x

# get command line parametres
LPORT=$1
IP=$2
DPORT=$3
SSHPORT=$4
TMP_SSH_RESULT="/tmp/ssh.result"
TMP_SSH_PID="/tmp/ssh.pid"
PRIVATE_KEY="/home/secuser/.ssh/otu_id_rsa_4096"

# ssh wait parameters (timeout is set to 15 seconds)
COUNTER=0
TESTTIMEOUT=15
SSH_UP=0

function usage ()
        {
    echo "usage : tpz_ssh_up local_port ip_address distant_port"
        }


# check for parametres
if [ $# != 4 ]
then
        usage
    exit 1
fi

# create ssh connnection
rm -f $TMP_SSH_RESULT
rm -f $TMP_SSH_PID

# lancement et detachement de ssh en mode tunnel, timeout a 15 secondes
ssh -i $PRIVATE_KEY -p $SSHPORT -o ConnectTimeout=$TESTTIMEOUT -o StrictHostKeyChecking=no -L $LPORT:localhost:$DPORT secuser@$IP -N 2> $TMP_SSH_RESULT &

# get PID as command returned value, and save to file
PID=$!
echo $PID > $TMP_SSH_PID

COUNTER=0
# wait for ssh connection AND local port forwarding
while [[ $COUNTER -lt $TESTTIMEOUT && "$SSH_UP" != "1" ]]; do
    sleep 1
    [ ! -d /proc/${PID} ] && COUNTER=$TESTTIMEOUT
    nc -dz localhost $LPORT && SSH_UP=1
    let COUNTER=COUNTER+1
done

# return exit code
if [ "$SSH_UP" == "1" ]
then
        # SUCCESS
        exit 0
else
        # FAILURE : on ne laisse pas ssh en memoire si on sort en timeout
        kill $PID > /dev/null 2>&1
        exit 1
fi
