#! /bin/sh
#simple sync of the rescue filesystem, based on inotifywait
 
PRG=$0

function usage ()
{
  echo "usage:"
  echo "    $PRG [--timeout <timeout in seconds> --type <file updated or renamed> ] file1 ... fileN"
  exit -1
}

set -- `getopt -n$0 -u --longoptions="timeout: type: help" "h" "$@"` || usage
[ $# -eq 0 ] && usage $0

# Get partition information
source /etc/otu/otuparts.sh

mkdir -p /mnt/fs/unused_part
mount | grep $ALT_PART || mount -o ro $ALT_PART /mnt/fs/unused_part
DEST=/mnt/fs/unused_part

#
# Manage arguments
TIMEOUT_RELOAD="-t 5"
MODIFICATION_TYPE="update"

echo "All parameters: $*"

#parse params for this script
while [ $# -gt 0 ]
do
    case "$1" in
       --timeout)		TIMEOUT_RELOAD="-t $2";shift 2;;
       --type)		    MODIFICATION_TYPE="$2";shift 2;;
	   --help)        	usage;shift;;
       -h)        	usage;shift;;
       --) 		shift;break;;       
    esac

done

LIST=$*
echo "LIST $LIST"

function do_copy ()
{
    date
    TARGET=$DEST/$1
    mountpoint -q $DEST
    [ "$?" != 0 ] && logger "Unused part not mounted, sync not done."  && return
    echo "Remounting rescue filesystem Read-Write"
    mount -o remount,rw $DEST
    [ ! -e  `dirname $TARGET` ] && mkdir -p `dirname $TARGET`
    if [ -f "$1" ] ; then
        echo "copying $1 to $TARGET"
        cp -a "$1" ${TARGET} ; sync
    else
        # removed file
        rm -f ${TARGET} ; sync
    fi
    echo "Remounting rescue filesystem Read-Only"
    mount -o remount,ro $DEST
}

function do_remove ()
{
    date
    TARGET=$DEST/$1
    mountpoint -q $DEST
    [ "$?" != 0 ] && logger "Unused part not mounted, sync not done."  && return
    echo "Remounting rescue filesystem Read-Write"
    mount -o remount,rw $DEST
    [ ! -e  `dirname $TARGET` ] && mkdir -p `dirname $TARGET`
    # remove file
    rm -f ${TARGET} ; sync
    echo "Remounting rescue filesystem Read-Only"
    mount -o remount,ro $DEST
}

function loop()
{
  previous_file=
  TIMEOUT=
  while [ true ]
  do	
	next_file=$(read $TIMEOUT; echo $REPLY)
	if [ -z "$next_file" ] ; then
		TIMEOUT=
    else
        echo "file changed: $next_file"
		TIMEOUT=$TIMEOUT_RELOAD
	fi
	if [ "$next_file" != "$previous_file" ] ; then
	  [ ! -z $previous_file ] && do_copy $previous_file
	fi
	previous_file=$next_file  
  done
}

function loopDir()
{
   while read path action file; 
   do         
      echo "The file '$file' changed in directory '$path' via '$action'";
      if [ ! -z $file ] ; then
         if [ "$action" != "DELETE" ] ; then
            do_copy $path$file
         else
            do_remove $path$file
         fi
      fi       
   done
}

# copie du fichier sur le rescue, s'il n'y a pas d'erreur de lecture de la sortie de inotify
function copy_file()
{
   read file_name
   RESULT=$?
   echo "file modified (renamed): $file_name - read status: $RESULT"
   [ ! -z $file_name ] && do_copy $file_name
   return $RESULT
}

# lorsque l'on ecoute avec inotifywait des fichiers dont l'inode change lors d'une modification (/etc/shadow...),
# il faut relancer inotifywait apres chaque evenement detecte pour le reinscrire sur le nouveau fichier
function start_inotify_rename()
{
   while [ true ]
   do
       inotifywait --format %w -e ATTRIB $LIST | copy_file
       RESULT=$?
       echo "inotifywait loop status: $RESULT"
       # on sort en erreur de lecture lors d'un arret par pkill, il faut alors sortir de la boucle while
       [[ "$RESULT" != "0" ]] && exit 3
   done
}

# inotify expects the file to exist. If it doesn't, then we create it.
# do not create empty ssu.conf, isu can't manage it!
for i in $LIST ; do ([ ! -e $i ] && [ "$i" != "/acterna/storage/share/ssu.conf" ] && touch $i) ; done

## inotify expects the file to exist. If it doesn't, then we remove it from the list
#for i in $LIST ; do [ -e $i ] && NEWLIST="$i $NEWLIST" ; done
#LIST=$NEWLIST

case "$MODIFICATION_TYPE" in
	update)
        echo "inotifywait --format %w -m -e MODIFY $LIST | loop"
		inotifywait --format %w -m -e MODIFY $LIST | loop
		;;
	rename)
        echo "inotifywait --format %w -e ATTRIB $LIST | copy_file"
		start_inotify_rename
		;;
	updateDir)
        echo "inotifywait --exclude \.part -m -e ATTRIB -e MODIFY -e DELETE $LIST | loopDir"
        inotifywait --exclude \.part -m -e ATTRIB -e MODIFY -e DELETE $LIST | loopDir
		;;
	*)
		echo $"Usage: $0 {update|rename|updateDir} {files list}"
		exit 2
esac

exit 0

