#!/bin/bash
#
#	Install silently the unused partition with a version given as first agument
#

INSTALLATION_DIR=$1
LOG_FILE=/otu/release/current/duplication_status
RELEASE_MANAGER_PID=$(pgrep release-manager)

function log_msg() {
   echo $* >> $LOG_FILE
   echo $*
}

function failed() {
    log_msg "Duplication failed"
    rm ${INSTALLATION_DIR}/first_boot_after_upgrade.tmp
    exit -1
}

rm -f $LOG_FILE
echo $(date) > $LOG_FILE
tail -n 0 -f /var/log/daemon.log &
LOG_REDIRECT=$!

log_msg "Duplicating"
release-manager start_upgrade 0:${INSTALLATION_DIR}/release.xml
if [ "$?"  != "0" ]; then
    logger "Release-manager client has failed to start"
    log_msg "Duplication failed"
    rm ${INSTALLATION_DIR}/first_boot_after_upgrade.tmp
    exit -1
else
    sleep 1  		# lets the daemon start its job
fi
# Do not sync when duplicating
/etc/init.d/otu_rfs_sync.sh stop

# Wait for the upgrade to be completed
OPERATION_COMPLETED="NO"

while [ $OPERATION_COMPLETED == "NO" ] ; do
    sleep 1
    kill -0 $RELEASE_MANAGER_PID
    [ $? -ne 0 ] && logger "Release-manager has stopped (probably crash!), upgrade failed" && failed
    ! [ -e /var/lib/release-manager/upgrade_status ] &&  logger "No status file for upgrade! upgrade failed" && failed
    CURRENT_STATUS=$(head -1 /var/lib/release-manager/upgrade_status)
    if [ "$CURRENT_STATUS" != "Started" ]
    then
        kill ${LOG_REDIRECT}
        if [ "$CURRENT_STATUS" == "Success" ]
        then
            fw_setenv upgrade_pending
            log_msg "Duplication succeed"
        else
            log_msg "Duplication failed"
        fi
        # Do not mark partition has the next to be boot, it is a duplication
        fw_setenv mmc_part_volatile
        OPERATION_COMPLETED="YES"
    fi
done

# At the end check if unused part is mounted and do it if necessary
# Get partition information
source /etc/otu/otuparts.sh
if [ -d /mnt/fs/unused_part ] ; then
    mkdir -p /mnt/fs/unused_part
fi
mountpoint -q /mnt/fs/unused_part || mount -o ro ${ALT_PART} /mnt/fs/unused_part

rm ${INSTALLATION_DIR}/first_boot_after_upgrade.tmp
sync
# Do sync when duplication is complete
/etc/init.d/otu_rfs_sync.sh start

exit 0
