#!/bin/bash
#  This script configure usb gadget using configfs for the following functions :
# 		- RNDIS (Eth)
#		- Serial port (console)
#
#
#

# First of all insure every mount and mod is done
GADGET_DIR=/sys/kernel/config/usb_gadget/g1


mount | grep /sys/kernel/config > /dev/null
if [ $? -ne 0 ] ; then
	mount -t configfs none /sys/kernel/config
	sleep 0.5
fi

lsmod | grep usb_f_rndis > /dev/null
if [ $? -ne 0 ] ; then
	modprobe usb_f_rndis
	sleep 0.5
fi

lsmod | grep usb_f_serial > /dev/null
if [ $? -ne 0 ] ; then
	modprobe usb_f_serial
fi

install_gadget() {
	mkdir -p ${GADGET_DIR}

	# Wait for configFS to do the job
	sleep 0.2

	cd ${GADGET_DIR}

	# Declare global USB information
	#echo "0xC1CB" > idVendor
	#echo "0xBAA2" > idProduct
	echo "0x158e" > idVendor 		# jdsu
	echo "0xa410" > idProduct		# 42000
	echo "0x0100" > bcdDevice		# 1.0
	echo "0x0200" > bcdUSB			# 2.0
	
	# Setting usb class seem to not working
	# echo "0xEF" > bDeviceClass
	# echo "0x04" > bDeviceSubClass
	# echo "0x01" > bDeviceProtocol

	# Give user visible description
	mkdir strings/0x409
	sleep 0.2
	echo "ste-rndis" > strings/0x409/serialnumber
	echo "Viavi" > strings/0x409/manufacturer
	echo "Viavi Ethernet Gadget" > strings/0x409/product

	# Create and configure RNDIS interface
	mkdir functions/rndis.rn0
	mkdir configs/c1.1
	# Configure Windows specifics info for W10, if not the device will be seen as COM port
	echo 1 > os_desc/use
	echo "0xbc" > os_desc/b_vendor_code
	echo MSFT100 > os_desc/qw_sign
	echo "RNDIS" > functions/rndis.rn0/os_desc/interface.rndis/compatible_id
	echo "5162001" > functions/rndis.rn0/os_desc/interface.rndis/sub_compatible_id
	ln -s functions/rndis.rn0/ configs/c1.1/

#	# Create a serial port
#	mkdir functions/acm.GS0
#	ln -s functions/acm.GS0/ configs/c1.1/

	# Gadget activation on usb0 
	echo "ci_hdrc.0" > UDC

	# Wait and configure dhcp for ethernet and tty for serial port
	sleep 1
	ifconfig usb0 192.168.2.1 up && dhcpd -cf /etc/dhcp/dhcpd_usbc.conf usb0

#	/bin/start_getty 115200 ttyGS0 &
}

remove_gadget() {
	ifconfig usb0 down
	#ps axu | grep ttyGS0 | grep getty | tr -s " " | cut -f2 -d " " | xargs kill
	ps axu | grep usb0 | grep dhcpd | tr -s " " | cut -f2 -d " " | xargs -r kill

	cd ${GADGET_DIR}
	
	if [[ $(cat UDC) != "" ]] ; then
		echo "Stopping gadgets"
		echo "" > UDC
		#rm -rf configs/c1.1/acm.GS0
		#[ -d functions/acm.GS0 ] && rmdir functions/acm.GS0
		
		rm -f configs/c1.1/rndis.rn0
		[ -d functions/rndis.rn0 ] && rmdir functions/rndis.rn0
		
		rmdir configs/c1.1
		
		rmdir strings/0x409

		cd ..
		rmdir ${GADGET_DIR}
	fi
}

state_of_gadget() {
	mkdir -p ${GADGET_DIR}
	cd ${GADGET_DIR}
	if [[ $(cat UDC) != "" ]] ; then
		echo "Gadgets are running"
	else
		echo "Gadgets are not running"
	fi
}


# Do not use usbc rndis in Otu mode
if [ -f /usr/lib/otu_functions ] ; then
    source /usr/lib/otu_functions
    is_cotu_hw
    [ $? -ne 0 ] && exit 0
fi

case $1 in

start)
	install_gadget
	;;
stop)
	remove_gadget
	;;
status)
	state_of_gadget
	;;
*)
	echo "Usage: $0 start|stop|status"
	exit -1
	;;
esac
exit 0
