#!/bin/sh

do_start() {
   /etc/init.d/snmpd start
   /etc/init.d/snmp-agent start
}

do_stop() {
   /etc/init.d/snmpd stop
   /etc/init.d/snmp-agent stop

}

case "$1" in
    start)
        do_start
        ;;
    stop)
        do_stop
        ;;
    restart)
        do_stop
        do_start
        ;;
    *)
        echo "Usage: /etc/init.d/snmp.sh {start|stop|restart}"
        exit 1
        ;;
esac

exit 0

