import QtQuick 2.3
import "Viavi_Colors.js" as VColor
import libfo 1.0

Rectangle {
    width: 500
    height: 400

    border.width: 2
    border.color: VColor.cViaviColorGray
    color: VColor.cViaviColorWhite

    property int items_margin: 10
    property int scrollbar_width: 5
    property real ratio_taille_popup_ratio: 5.0/6.0
    property int alinea_subline: title.width / 16
    

    // members
    property int selected_ratio_opened : -1;

    property bool warningOnScreen: (popUpProgress_LaunchCable.visible || measPopUp.visible)
    
    Rectangle {
        id: title
        width: parent.width
        height: 30
        color: VColor.cViaviColorGray
        anchors.top : parent.top
        
        visible: false
        
        Text {
            id: titleTxt
            width: parent.width / 2
            height: parent.height

            wrapMode: Text.Wrap
            color: VColor.cViaviColorWhite
            text: windows_manager.txtTitleSetupWindow
            font.pixelSize: 20
            horizontalAlignment: Text.AlignLeft
            verticalAlignment:  Text.AlignVCenter
        }
     }

    Flickable
    {
        id: flickableContainer
        enabled: !(keypad.visible || listSelection.visible || warningOnScreen)

        anchors.left: parent.left
        anchors.leftMargin: items_margin
        anchors.right: parent.right
        anchors.rightMargin: items_margin + indicatorFlickable.width
        anchors.top: parent.top
        anchors.topMargin: items_margin
        anchors.bottom: buttonSelection.top
        anchors.bottomMargin: items_margin
        
        clip: true
        boundsBehavior: Flickable.StopAtBounds
        interactive: contentHeight >  height
        
        contentHeight: lineContainer.height
        
        onContentYChanged: {
            indicatorFlickable.value = parseInt(contentY, 10) * 100 / flickableContainer.contentHeight;
        }
        
        onHeightChanged: indicatorFlickable.ratio = (indicatorFlickable.height + items_margin)  * 100 / (flickableContainer.contentHeight);
        onContentHeightChanged: indicatorFlickable.ratio = (indicatorFlickable.height + items_margin)  * 100 / (flickableContainer.contentHeight);

        contentY: parseInt(indicatorFlickable.value * flickableContainer.contentHeight / 100 , 10)

        Item {
            id: lineContainer

            height: columnContainer.height + items_margin
            width: parent.width - 2 * items_margin
            
            Column {
                id: columnContainer
                spacing: items_margin
                width: parent.width
                
                property real sublineWidth: ( width / 3 -  2 * items_margin )

                Wizard_Setup_Message_Box_Line {
                    id: testFeatureChoice

                    visible: setup_data.testFeatureSelection.isVisible

                    inputText:  setup_data.testFeatureSelection.itemHeader
                    inputModel: setup_data.testFeatureSelection.itemModel
                    isExclusive: setup_data.testFeatureSelection.isExclusive
 
                    onSelectValueChanged: { setup_data.testFeatureSelection.Wizard_Item_Selection_Update(index); }
                }
                
                Wizard_Setup_Message_Box_Line {
                    id: laserChoice

                    visible: setup_data.laserSelection.isVisible && !setup_data.isDwdm

                    inputText:  setup_data.laserSelection.itemHeader
                    inputModel: setup_data.laserSelection.itemModel
                    isExclusive: setup_data.laserSelection.isExclusive
                    isError: !setup_data.isAvailable

                    onSelectValueChanged: { setup_data.laserSelection.Wizard_Item_Selection_Update(index); }
                }
                
                Rectangle {
                    width: parent.width
                    height: 60

                    color: "transparent"

                    visible: setup_data.dwdmLaserSelection.isVisible && setup_data.isDwdm

                    Wizard_Setup_Message_Box_Line {
                        id: dwdmUnitChoice 
                        
                        anchors.left: parent.left
                        anchors.right: subLineDwdmLaserChoice.left
                        anchors.rightMargin: 2
                        
                        inputText:  setup_data.dwdmLaserSelection.itemHeader
                        inputModel: setup_data.dwdmLaserSelection.itemModel
                        isExclusive: setup_data.dwdmLaserSelection.isExclusive
                        
                        onSelectValueChanged: { setup_data.dwdmLaserSelection.Wizard_Item_Selection_Update(index); }
                    }
	                
	                Wizard_Setup_Message_Box_SubLine {
	                     id: subLineDwdmLaserChoice
						 width: columnContainer.sublineWidth
						 headerVisible: false
	
	                     anchors.right: parent.right
	
	                     inputText: setup_data.dwdmLaserSelection.subLineHeader
	                     outputValue: setup_data.dwdmLaserSelection.subLineValue
	                     enableSelection: setup_data.dwdmLaserSelection.subLineEnabled
	                     
                   function onOKDwdmLaser(idx)
                      {
                  	 setup_data.dwdmLaserSelection.positionList = idx;
                  	 listSelection.btnOkClicked.disconnect(onOKDwdmLaser);
                      }
                      
                   function onNOKDwdmLaser(idx)
                      {
                  	 listSelection.btnCancelClicked.disconnect(onNOKDwdmLaser);
                      }

	                    onOpenEditorClicked: {
					        listSelection.label = setup_data.dwdmLaserSelection.subLineHeader
					        listSelection.model_list = setup_data.dwdmLaserSelection.dwdmLaserList
					        listSelection.current_idx_selected = setup_data.dwdmLaserSelection.positionList;
					        listSelection.visible = true;
					        listSelection.btnOkClicked.connect(onOKDwdmLaser);
					        listSelection.btnCancelClicked.connect(onNOKDwdmLaser);
	                    }
	                }
                }


                Wizard_Setup_Message_Box_Line {
                    id: directionChoice

                    visible: setup_data.directionSelection.isVisible

                    inputText:  setup_data.directionSelection.itemHeader
                    inputModel: setup_data.directionSelection.itemModel
                    isExclusive: setup_data.directionSelection.isExclusive

                    onSelectValueChanged: { setup_data.directionSelection.Wizard_Item_Selection_Update(index); }
                }


                Rectangle {
                    width: parent.width
                    height: setup_data.splittersSelection.isRatioVisible ? 60 * 2 + items_margin : 60
                    color: "transparent"

                    visible: setup_data.splittersSelection.isVisible

                    Wizard_Setup_Message_Box_Line {
                        id: splittersChoice
                        width: parent.width
                        inputText:  setup_data.splittersSelection.itemHeader
                        inputModel: setup_data.splittersSelection.itemModel
                        isExclusive: setup_data.splittersSelection.isExclusive

                        onSelectValueChanged: {
                            setup_data.splittersSelection.Wizard_Item_Selection_Update(index);
                        }

                    }



                    Row {
                        id: splitters_ratio
                        anchors.left: parent.left
                        anchors.right: parent.right
                        anchors.top: splittersChoice.bottom
                        anchors.topMargin: items_margin
                        spacing: items_margin
                        
                        visible: setup_data.splittersSelection.isRatioVisible

                        Rectangle {
                            id: ont
                            width: alinea_subline / 2
                            height: splitters_ratio.height
                            color: VColor.cViaviColorGray
                            anchors.verticalCenter: parent.verticalCenter
                            Text {
                                text: windows_manager.txtOLTHeader
                                font.pixelSize: 18
                                color: VColor.cViaviColorWhite
                                anchors.centerIn: parent
                                rotation: -90
                                transformOrigin: Item.Center
                                verticalAlignment: Text.AlignVCenter
                                horizontalAlignment: Text.AlignHCenter
                            }

                        }
                        Repeater {
                            model: setup_data.splittersSelection.listRatio
                            
                            Wizard_Setup_Message_Box_SubLine {
                                id: subLineSplitter1
                                width:  ( splitters_ratio.width - 2 * items_margin - alinea_subline - 2 * items_margin ) / 3;
                                inputText: setup_data.splittersSelection.listRatio[index].name
                                outputValue: setup_data.splittersSelection.listRatio[index].ratioSelectedName
                                enableSelection: setup_data.splittersSelection.listRatio[index].visible
                                headerVisible: true
                                
                                function onOKRatio(value)
							    {
							        if( selected_ratio_opened >= 0  )
							        {
							            setup_data.splittersSelection.listRatio[selected_ratio_opened].ratioSelected = value;
							            setup_data.splittersSelection.Wizard_Item_Selection_Validate_Ratio();
							            selected_ratio_opened = -1;
							        }
							        listSelection.btnOkClicked.disconnect(onOKRatio);
							    }
							    
							    function onNOKRatio(value)
							    {
							        setup_data.splittersSelection.Wizard_Item_Selection_Restore_Ratio();
							        selected_ratio_opened = -1;
							        listSelection.btnCancelClicked.disconnect(onNOKRatio);
							    }
                                
                                onOpenEditorClicked: {
							        selected_ratio_opened = index;
							        listSelection.label = windows_manager.txtLoadRatioHeader
							        listSelection.model_list = setup_data.splittersSelection.listRatio[index].ratioList;
							        listSelection.current_idx_selected = setup_data.splittersSelection.listRatio[index].ratioSelected;
							        listSelection.visible = true;
							        listSelection.btnOkClicked.connect(onOKRatio);
							        listSelection.btnCancelClicked.connect(onNOKRatio);
                                }
                            }
                        }
                        Rectangle {
                            id: olt
                            width: alinea_subline / 2
                            height: splitters_ratio.height
                            color: VColor.cViaviColorGray
                            anchors.verticalCenter: parent.verticalCenter
                            Text {
                                text: windows_manager.txtONTHeader
                                font.pixelSize: 18
                                color: VColor.cViaviColorWhite
                                anchors.centerIn: parent
                                rotation: 90
                                transformOrigin: Item.Center
                                verticalAlignment: Text.AlignVCenter
                                horizontalAlignment: Text.AlignHCenter
                            }
                        }
                    }
                }
                Wizard_Setup_Message_Box_Line {
                    id: distanceUnitChoice

                    visible: setup_data.unitsSelection.isVisible

                    inputText:  setup_data.unitsSelection.itemHeader
                    inputModel: setup_data.unitsSelection.itemModel
                    isExclusive: setup_data.unitsSelection.isExclusive

                    onSelectValueChanged: { setup_data.unitsSelection.Wizard_Item_Selection_Update(index); }
                }

                Rectangle {
                    width: parent.width
                    height: 60

                    color: "transparent"

                    visible: setup_data.launchCableSelection.isVisible

                    Wizard_Setup_Message_Box_Line {
                        id: launchCableChoice
                        
                        anchors.left: parent.left
                        anchors.right: subLineLaunchCableChoice.left
                        anchors.rightMargin: 2

                        inputText:  setup_data.launchCableSelection.itemHeader
                        inputModel: setup_data.launchCableSelection.itemModel
                        isExclusive: setup_data.launchCableSelection.isExclusive

                        onSelectValueChanged: { setup_data.launchCableSelection.Wizard_Item_Selection_Update(index); }
                    }

                    Wizard_Setup_Message_Box_SubLine {
                        id: subLineLaunchCableChoice
                        width: columnContainer.sublineWidth
                        anchors.right: parent.right
                        
                        visible: setup_data.launchCableSelection.subLineIsEnabled

                        inputText: setup_data.launchCableSelection.subLineHeader
                        outputValue: setup_data.launchCableSelection.subLineValue
                        enableSelection: setup_data.launchCableSelection.subLineIsEnabled
                        
                        function editNumber(txtOutput, validation) {   
						         if (validation === true)
						            {
						            setup_data.launchCableSelection.subLineValue = txtOutput;
						            }        
						    
						         keypad.editText.disconnect(editNumber); 
					         }

                        onOpenEditorClicked: {
                            keypad.visible = true;
                            keypad.titleText = setup_data.launchCableSelection.itemHeader;
                            keypad.initialText = setup_data.launchCableSelection.subLineValue;
                            keypad.minValue = setup_data.launchCableSelection.launchCableMinValue;
        					       keypad.maxValue = setup_data.launchCableSelection.launchCableMaxValue; 
                            keypad.measIsVisible = true;
                            keypad.measIsAllowed = setup_data.isAvailable;
                            keypad.editText.connect(editNumber);	
                        }
                    }
                }

                Text {
                    text: setup_data.launchCableSelection.launchCableWarning
                    visible: setup_data.launchCableSelection.launchCableWarningDisplay
                    font.pixelSize: 18
                    color: VColor.cViaviColorRed
                    anchors.horizontalCenter: parent.horizontalCenter
                    wrapMode: Text.Wrap
                }

                Rectangle {
                    width: parent.width
                    height: 60

                    color: "transparent"

                    visible: setup_data.receiveCableSelection.isVisible

                    Wizard_Setup_Message_Box_Line {
                        id: receiveCableChoice
                        
                        anchors.left: parent.left
                        anchors.right: subLineReceiveCableChoice.left
                        anchors.rightMargin: 2

                        inputText:  setup_data.receiveCableSelection.itemHeader
                        inputModel: setup_data.receiveCableSelection.itemModel
                        isExclusive: setup_data.receiveCableSelection.isExclusive

                        onSelectValueChanged: { setup_data.receiveCableSelection.Wizard_Item_Selection_Update(index); }
                    }

                    Wizard_Setup_Message_Box_SubLine {
                        id: subLineReceiveCableChoice
                        width: columnContainer.sublineWidth
                        anchors.right: parent.right
                        
                        visible: setup_data.receiveCableSelection.subLineIsEnabled

                        inputText: setup_data.receiveCableSelection.subLineHeader
                        outputValue: setup_data.receiveCableSelection.subLineValue
                        enableSelection: setup_data.receiveCableSelection.subLineIsEnabled
                        
                        function editNumber(txtOutput, validation) {   
						         if (validation === true)
						            {
						            setup_data.receiveCableSelection.subLineValue = txtOutput;
						            }        
						    
						         keypad.editText.disconnect(editNumber); 
					          }

                        onOpenEditorClicked: {
                            keypad.visible = true;
                            keypad.titleText = setup_data.receiveCableSelection.itemHeader;
                            keypad.initialText = setup_data.receiveCableSelection.subLineValue;
                            keypad.minValue = setup_data.receiveCableSelection.receiveCableMinValue;
        					       keypad.maxValue = setup_data.receiveCableSelection.receiveCableMaxValue; 
                            keypad.editText.connect(editNumber);	
                            keypad.measIsVisible = false;                            
                            keypad.measIsAllowed = false;
                        }
                    }
                }
                
                Rectangle {
                    width: parent.width
                    height: 60

                    color: "transparent"

                    visible: setup_data.alarmSelection.isVisible

                    Wizard_Setup_Message_Box_Line {
                        id: alarmChoice
                        
                        anchors.left: parent.left
                        anchors.right: subLineAlarmChoice.left
                        anchors.rightMargin: 2

                        inputText:  setup_data.alarmSelection.itemHeader
                        inputModel: setup_data.alarmSelection.itemModel
                        isExclusive: setup_data.alarmSelection.isExclusive

                        onSelectValueChanged: { setup_data.alarmSelection.Wizard_Item_Selection_Update(index); }
                    }

                    Wizard_Setup_Message_Box_SubLine {
                        id: subLineAlarmChoice
                        width: columnContainer.sublineWidth

                        anchors.right: parent.right
                        
                        visible: setup_data.alarmSelection.subLineIsEnabled

                        inputText: setup_data.alarmSelection.subLineHeader
                        outputValue: setup_data.alarmSelection.subLineValue
                        enableSelection: setup_data.alarmSelection.subLineIsEnabled
                        
                        function onOKAlarm(idx) {
					             setup_data.alarmSelection.positionList = idx;
					             listSelection.btnOkClicked.disconnect(onOKAlarm);
					         }
					    
					         function onNOKAlarm(idx) {
					             listSelection.btnCancelClicked.disconnect(onNOKAlarm);
					         }
                        
                        onOpenEditorClicked: {
   					        listSelection.label = windows_manager.txtLoadAlarmHeader
   					        listSelection.model_list = setup_data.alarmSelection.thresholdList
   					        listSelection.current_idx_selected = setup_data.alarmSelection.positionList;
   					        listSelection.visible = true;
   					        listSelection.btnOkClicked.connect(onOKAlarm);
   					        listSelection.btnCancelClicked.connect(onNOKAlarm);    
                        }
                    }
                }
            }
        }

    }
    
    Slider {
        id: indicatorFlickable
        width: (visible == true) ? scrollbar_width : 0
        orientation : Qt.Vertical

        anchors.right: parent.right
        anchors.rightMargin: items_margin

        anchors.top: flickableContainer.top
        anchors.topMargin: items_margin / 2
        anchors.bottom: flickableContainer.bottom
        anchors.bottomMargin: items_margin / 2

        visible: flickableContainer.contentHeight >  flickableContainer.height

        ratio: (indicatorFlickable.height + items_margin)  * 100 / (flickableContainer.contentHeight)
    }

    Wizard_Setup_Message_Box_Button {
        id: buttonSelection
        anchors.bottom: parent.bottom
        
        width: parent.width
        height: 70

        enabled: !(keypad.visible || listSelection.visible || warningOnScreen)
    }

    Key_Pad {
        id: keypad
        visible: false
        enabled: !warningOnScreen

        anchors.centerIn: parent
    }

    Wizard_Setup_Message_Box_Listview {
        id: listSelection
        width: parent.width / 2
        height: parent.height - 2 * items_margin
        visible:false
        anchors.centerIn: parent
    }
    
    Pop_Up_Warning {
    	id: measPopUp
        
        visible: (setup_data.launchCableSelection.displayMeasInfo || setup_data.launchCableSelection.measureFailedWarning)
        focus: (setup_data.launchCableSelection.displayMeasInfo || setup_data.launchCableSelection.measureFailedWarning)
        
        function startMeas() {
			setup_data.launchCableSelection.Wizard_Meas_Launch_Cable();
		}
		
		function cancelMeas() {
			setup_data.launchCableSelection.Wizard_Cancel_Meas_Launch_Cable();
			subLineLaunchCableChoice.openEditorClicked();
		}
		        
        onVisibleChanged: {
        	if ( setup_data.launchCableSelection.displayMeasInfo )
        	   {
        	keypad.editText.disconnect(subLineLaunchCableChoice.editNumber);
            measPopUp.warningType = "Info";
            measPopUp.numberOfButtons = 2;
            measPopUp.warningText = windows_manager.txtMeasLaunchCableInfo;
            measPopUp.warningSubText = "";
            measPopUp.warningClicked.disconnect(cancelMeas);
            measPopUp.btnLText = windows_manager.txtConfirm;
            measPopUp.btnLClicked.connect(startMeas);
            measPopUp.btnRText = windows_manager.txtCancel;
            measPopUp.btnRClicked.connect(cancelMeas);
        	   }
        	else if ( setup_data.launchCableSelection.measureFailedWarning )
        	   {
	         measPopUp.warningType = "Error";
	         measPopUp.numberOfButtons = 0;
	         measPopUp.warningText = windows_manager.txtMeasLaunchCableFail;
	         measPopUp.warningSubText = windows_manager.txtMeasLaunchCableFail2;
	         measPopUp.clickToExitText = windows_manager.txtClickToExit;
	         measPopUp.btnLClicked.disconnect(startMeas);
   	      measPopUp.btnRClicked.disconnect(cancelMeas);
   	      measPopUp.warningClicked.connect(cancelMeas);
        	   }
        	else
           	{
           	measPopUp.warningClicked.disconnect(cancelMeas);
           	measPopUp.warningText = "";
           	measPopUp.warningSubText = "";
           	measPopUp.btnLClicked.disconnect(startMeas);
   	      measPopUp.btnRClicked.disconnect(cancelMeas);
           	}
        }
    }
    
    Pop_Up_Warning {
    	id: popUpProgress_LaunchCable
    	
    	warningType: "Progress"

    	visible: setup_data.launchCableSelection.isMeasInProgress
		focus: setup_data.launchCableSelection.isMeasInProgress
		
		numberOfButtons: 1
		
		function stopMeas() {
			setup_data.launchCableSelection.Wizard_Stop_Meas_Launch_Cable();
		}
		
		onVisibleChanged: {
			if ( setup_data.launchCableSelection.isMeasInProgress )
				{
				popUpProgress_LaunchCable.warningText = windows_manager.txtMeasLaunchCableProgress;
				popUpProgress_LaunchCable.warningSubText = "";
				popUpProgress_LaunchCable.btnRText = windows_manager.txtCancel;
				popUpProgress_LaunchCable.btnRClicked.connect(stopMeas);
				}
			else
				{
				popUpProgress_LaunchCable.warningText = "";
				popUpProgress_LaunchCable.warningSubText = "";
				popUpProgress_LaunchCable.btnRClicked.disconnect(stopMeas);				
				}
		}
		
		anchors.centerIn: parent
		
		inProgress: setup_data.launchCableSelection.isMeasInProgress
		
		
    }
}
