import QtQuick 2.3
import "Viavi_Colors.js" as VColor
import libfo 1.0

Rectangle {
   id: container
   
   width: 600
   height: 70
   
   color: VColor.cViaviColorLightGray2
    
   property bool validationIsPossible: false
    
   property int buttonWidth: container.height * 1.5
   property int buttonHeight: container.height
   
   property int textSize: 18
   
   Rectangle {
      anchors.top: parent.top
      anchors.bottom: parent.bottom
      anchors.left: parent.left
      anchors.right: rowButtons.left
      anchors.rightMargin: 2
    
      color: VColor.cViaviColorGray
    
      Text {
         id: configTxt
         
         anchors.fill: parent
         color: VColor.cViaviColorLightGray2
         
         anchors.left: parent.left
         anchors.leftMargin: 10
         anchors.verticalCenter: parent.verticalCenter
         
         text: recording_information_data.dirName
         verticalAlignment: Text.AlignVCenter
         horizontalAlignment: Text.AlignLeft
         font.pixelSize: 20
         font.italic: true
         wrapMode: Text.Wrap
         
         clip: true
       }
    }
       
    Row {
      id: rowButtons
      
      anchors.top: parent.top
      anchors.bottom: parent.bottom
      anchors.right: parent.right
      
      layoutDirection: Qt.RightToLeft
      
      spacing: 2
      
      Rectangle {
         id: resultButton
         width: buttonWidth
         height: buttonHeight
         
         color: VColor.cViaviColorGray
         
         enabled: true
         opacity: enabled ? ( mouseAreaResultButton.pressed ? 0.8 : 1 ) : 0.4
         visible: true
         
         Text {
             id: textResults
             color: VColor.cViaviColorWhite
             
             anchors.top: parent.top
             anchors.topMargin: 2
             anchors.horizontalCenter: parent.horizontalCenter
             
             text: windows_manager.txtResults
             
             horizontalAlignment: Text.AlignHCenter
             
             font.pixelSize: textSize
             font.bold: mouseAreaResultButton.pressed
             wrapMode: Text.Wrap             
         }
                
         Image {
            source: "/acterna/storage/look-and-feel/generic/icon_popup_view_results.png"
         
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 2
            anchors.top: textResults.bottom
            anchors.topMargin: 2
            anchors.horizontalCenter: parent.horizontalCenter
            
            fillMode: Image.PreserveAspectFit
            smooth: true
         }
         
         MouseArea {
            id: mouseAreaResultButton
            
             anchors.fill: parent
             onClicked: {
               windows_manager.Close_Recording_Information_Windows(); 
             }           
         }
       }
	    
	    Rectangle {
	        id: filePdfButton
	        width: buttonWidth
	        height: buttonHeight
	        color: VColor.cViaviColorGray
	
	        anchors.verticalCenter: parent.verticalCenter
	        
	        enabled: validationIsPossible
	        opacity: validationIsPossible ? ( mouseAreaFilePdf.pressed ? 0.8 : 1 ) : 0.4
	        
	        visible: recording_information_data.filePdfVisible
	        
	        Text {
	            color: VColor.cViaviColorWhite
	            anchors.fill: parent
	            text: windows_manager.txtFilePdf
	            horizontalAlignment: Text.AlignHCenter
	            verticalAlignment:  Text.AlignVCenter
	            font.pixelSize: textSize
	            font.bold: mouseAreaFilePdf.pressed
	        }
	
	        MouseArea {
	        	id: mouseAreaFilePdf
	        
	            anchors.fill: parent
	            onClicked: {
	            if ( validationIsPossible != false )
	               {
	               recording_information_data.Wizard_Save_Acquisition( RecordingInformationData.CRecording_File_Pdf );
	               windows_manager.Close_Recording_Information_Windows();
	               }
	            }
	        }
	    }
	    
	    Rectangle {
	        id: fileTxtButton
	        width: buttonWidth
	        height: buttonHeight
	        color: VColor.cViaviColorGray
	
	        anchors.verticalCenter: parent.verticalCenter
	        
	        enabled: validationIsPossible
	        opacity: validationIsPossible ? ( mouseAreaFileTxt.pressed ? 0.8 : 1 ) : 0.4
	        
	        visible: recording_information_data.fileTxtVisible
	        
	        Text {
	            color: VColor.cViaviColorWhite
	            anchors.fill: parent
	            text: windows_manager.txtFileTxt
	            horizontalAlignment: Text.AlignHCenter
	            verticalAlignment:  Text.AlignVCenter
	            font.pixelSize: textSize
	            font.bold: mouseAreaFileTxt.pressed
	        }
	
	        MouseArea {
	        	id: mouseAreaFileTxt
	        	
	            anchors.fill: parent
	            onClicked: {
	            if ( validationIsPossible != false )
	               {
	               recording_information_data.Wizard_Save_Acquisition( RecordingInformationData.CRecording_File_Txt );
	               windows_manager.Close_Recording_Information_Windows();
	               }
	            }
	        }
	    }
	    
       Rectangle {
           id: fileOnlyButton
           width: buttonWidth
           height: buttonHeight
           color: VColor.cViaviColorGray
           anchors.verticalCenter: parent.verticalCenter
           
           enabled: validationIsPossible
           opacity: validationIsPossible ? ( mouseAreaFileOnly.pressed ? 0.8 : 1 ) : 0.4
           
           visible: recording_information_data.fileOnlyVisible
           
           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: windows_manager.txtFileOnly
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: textSize
               font.bold: mouseAreaFileOnly.pressed
           }
   
           MouseArea {
            id: mouseAreaFileOnly
            
               anchors.fill: parent
               
               onClicked: {
               if ( validationIsPossible != false )
                  {
                  recording_information_data.Wizard_Save_Acquisition( RecordingInformationData.CRecording_File_Only );
                  windows_manager.Close_Recording_Information_Windows();
                  }
               }
           }
       }

/*
       Rectangle {
           id: exitButton
           width: buttonWidth
           height: buttonHeight
           color: VColor.cViaviColorGray
           anchors.verticalCenter: parent.verticalCenter
           anchors.leftMargin: 20
           
           opacity: mouseAreaExit.pressed ? 0.8 : 1
   
           Text {
               color: VColor.cViaviColorWhite
               anchors.fill: parent
               text: windows_manager.txtExitRecording
               horizontalAlignment: Text.AlignHCenter
               verticalAlignment:  Text.AlignVCenter
               font.pixelSize: textSize
               font.bold: mouseAreaExit.pressed
           }
   
           MouseArea {
            id: mouseAreaExit
            
               anchors.fill: parent
               onClicked: {
                   windows_manager.Close_Recording_Information_Windows();
               }
           }
       }
       */
    }    
}
