import QtQuick 2.3
import libfo 1.0
import "Viavi_Colors.js" as VColor

Rectangle {
    id: container

    height: 30
    width:  700

    property string textColor: VColor.cViaviColorBlack
    property bool textBold: false
    property int textSize: 16

    property int widthSeparator: 2
    property string separatorColor: VColor.cViaviColorLightGray2

    color: IsSelected ? VColor.cViaviColorYellow : VColor.cViaviColorLightGray1
    
    function getAlarmColor( alarm ) 
    {
      var alarm_color = VColor.cViaviColorBlack
      
      switch( alarm )
      {
      case ResultTableElement.C_Warning_Status:
         alarm_color = VColor.cViaviColorYellow;
         break;
      case ResultTableElement.C_Error_Status:
         alarm_color = VColor.cViaviColorRed;
         break;
      case ResultTableElement.C_Pass_Status:
         alarm_color = VColor.cViaviColorGreen;
         break;
      default:
         alarm_color = VColor.cViaviColorBlack;
         break;
      }
      
      return alarm_color;
    }

    Row {
        anchors.fill: parent
        
        clip: true

        Repeater {
           id: repeaterId
           model: LineModel
           
           Rectangle {
              height: parent.height
              width: RatioWidth * parent.width / 100
              
              color: "transparent"
                 
              Rectangle {
                 color: "transparent"
                 
                 height: parent.height
                 width: parent.width - widthSeparator
                 
                 clip: true
   
                 Text {
                    visible: !IsIcon
                    text: !IsIcon ? ElementValue : ""
                     
                    width: parent.width
                    height: parent.height
                     
                    color: (parent.width == 0) ? "transparent" : getAlarmColor( StatusElement )
                     
                    font.pixelSize: textSize
                    font.family: "Bitstream Vera Sans Roman"
                    font.bold: textBold
                     
                    horizontalAlignment: Text.AlignHCenter
                    verticalAlignment: Text.AlignVCenter
                 }
                 
                 Image {
                    visible: IsIcon
                    
                    anchors.fill: parent
                    anchors.margins: 3
                    
                    fillMode: Image.PreserveAspectFit
                    smooth:true
                    source: IsIcon ? ElementValue : ""
                 }
              }
              
              // Separator
              Rectangle {
                  width: widthSeparator
                  height: parent.height - 4
                  
                  x: parent.width - widthSeparator
         
                  radius: 1
                  
                  visible: ( index < ( repeaterId.count - 1) )
         
                  anchors.verticalCenter: parent.verticalCenter
         
                  color: separatorColor
              }
           }
        }
    }
    
    MouseArea {
      anchors.fill: container
      
      onClicked: {
         resultTableItem.selectValueChanged( LineIndex );
      }
    }
}
