import QtQuick 2.3
import libfo 1.0
import "Viavi_Colors.js" as VColor

Rectangle {
    id: resultTableItem
    
    height: 200
    width: 700

    clip: true
    
    color: VColor.cViaviColorLightGray1

    property int currentIndexSelected: 0
    
    property alias titleModel:  titleRepeater.model
    property alias headerModel: headerRepeater.model
    property alias resultModel: resultRepeater.model
    
    property int nbResultLine: 0
    property int nbHeaderLine: 0
    property int nbTitleLine: 0
    
    property int lineHeight: 30
    
    // Signals
    signal selectValueChanged( int index );
    
    Column {
       spacing: 0
       
       Rectangle {
           id: title_container
           
           width: resultTableItem.width
           height: lineHeight * resultTableItem.nbTitleLine
           
           clip: true
           
           color: VColor.cViaviColorLightGray1
           
           Column {
               width: parent.width
               height: parent.height
               anchors.top: title_container.top
      
               clip: true
   
               Repeater {
                  id: titleRepeater
      
                  Result_Table_Header_Line {
                      width: title_container.width
                      
                      height: lineHeight
                  }
               }
           }
       }
    
       Rectangle {
           id: header_container
           
           width: resultTableItem.width
           height: lineHeight * resultTableItem.nbHeaderLine
           
           clip: true
           
           color: VColor.cViaviColorLightGray1
           
           Column {
               width: parent.width
               height: parent.height
               anchors.top: header_container.top
      
               clip: true
   
               Repeater {
                  id: headerRepeater
      
                  Result_Table_Header_Line {
                      width: header_container.width
                      
                      height: lineHeight
                  }
               }
           }
       }

       Rectangle {
           id: information_container
   
           width: resultTableItem.width
           height: resultTableItem.height - header_container.height - title_container.height
           
           color: VColor.cViaviColorLightGray1
           
           ListView {
               id: resultRepeater
               
               anchors.fill: parent
               
               highlightFollowsCurrentItem: false
               boundsBehavior: Flickable.StopAtBounds
               clip: true
               
               delegate:   Result_Table_Line_Item {
                              width: information_container.width
                              height: lineHeight
                           }
               
           }
       }
    }
}
