import QtQuick 2.3

Rectangle {
	id: buttonDelegate
	property string text: ""
	property Item iBox: {}
	color: "transparent"

	Image {
		anchors.fill: parent
		source: (buttonDelegate.text != "hidden" ) ? Pin.button_background : ""
	}
	Text {
		anchors.fill: parent;
		verticalAlignment: Text.AlignVCenter
		horizontalAlignment: Text.AlignHCenter

		font.family: "DejaVu LGC SansCondensed"
		font.bold: false
		font.pointSize: 16
		text: (buttonDelegate.text != "hidden" ) ? buttonDelegate.text : ""

		MouseArea {
			anchors.fill: parent;
			onClicked: {
				if ( buttonDelegate.text == "Back" )
					Pin.result = Pin.result.slice(0, Pin.result.length - 1 )
				else if ( buttonDelegate.text == "Enter" )
					Pin.closePincodeOk()
			    else if ( buttonDelegate.text == "hidden" )
                    Pin.result = Pin.result // ignore it but need to provoke a signal
				else
					Pin.result += buttonDelegate.text;
			}
		}
	}
}
