/*
* Copyright (c) 2009, Jeff Mott. All rights reserved. 
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     * Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     * Neither the name of the Crypto-JS nor the names of its contributors 
*       may be used to endorse or promote products derived from this software 
*       without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/

(function(){var c="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var d=window.Crypto={};var a=d.util={rotl:function(h,g){return(h<<g)|(h>>>(32-g))},rotr:function(h,g){return(h<<(32-g))|(h>>>g)},endian:function(h){if(h.constructor==Number){return a.rotl(h,8)&16711935|a.rotl(h,24)&4278255360}for(var g=0;g<h.length;g++){h[g]=a.endian(h[g])}return h},randomBytes:function(h){for(var g=[];h>0;h--){g.push(Math.floor(Math.random()*256))}return g},bytesToWords:function(h){for(var k=[],j=0,g=0;j<h.length;j++,g+=8){k[g>>>5]|=h[j]<<(24-g%32)}return k},wordsToBytes:function(i){for(var h=[],g=0;g<i.length*32;g+=8){h.push((i[g>>>5]>>>(24-g%32))&255)}return h},bytesToHex:function(g){for(var j=[],h=0;h<g.length;h++){j.push((g[h]>>>4).toString(16));j.push((g[h]&15).toString(16))}return j.join("")},hexToBytes:function(h){for(var g=[],i=0;i<h.length;i+=2){g.push(parseInt(h.substr(i,2),16))}return g},bytesToBase64:function(h){if(typeof btoa=="function"){return btoa(e.bytesToString(h))}for(var g=[],l=0;l<h.length;l+=3){var m=(h[l]<<16)|(h[l+1]<<8)|h[l+2];for(var k=0;k<4;k++){if(l*8+k*6<=h.length*8){g.push(c.charAt((m>>>6*(3-k))&63))}else{g.push("=")}}}return g.join("")},base64ToBytes:function(h){if(typeof atob=="function"){return e.stringToBytes(atob(h))}h=h.replace(/[^A-Z0-9+\/]/ig,"");for(var g=[],j=0,k=0;j<h.length;k=++j%4){if(k==0){continue}g.push(((c.indexOf(h.charAt(j-1))&(Math.pow(2,-2*k+8)-1))<<(k*2))|(c.indexOf(h.charAt(j))>>>(6-k*2)))}return g}};d.mode={};var b=d.charenc={};var f=b.UTF8={stringToBytes:function(g){return e.stringToBytes(unescape(encodeURIComponent(g)))},bytesToString:function(g){return decodeURIComponent(escape(e.bytesToString(g)))}};var e=b.Binary={stringToBytes:function(j){for(var g=[],h=0;h<j.length;h++){g.push(j.charCodeAt(h))}return g},bytesToString:function(g){for(var j=[],h=0;h<g.length;h++){j.push(String.fromCharCode(g[h]))}return j.join("")}}})();(function(){var g=Crypto,b=g.util,c=g.charenc,f=c.UTF8,e=c.Binary;var a=[1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298];var d=g.SHA256=function(j,h){var i=b.wordsToBytes(d._sha256(j));return h&&h.asBytes?i:h&&h.asString?e.bytesToString(i):b.bytesToHex(i)};d._sha256=function(q){if(q.constructor==String){q=f.stringToBytes(q)}var y=b.bytesToWords(q),z=q.length*8,r=[1779033703,3144134277,1013904242,2773480762,1359893119,2600822924,528734635,1541459225],s=[],K,J,I,G,F,E,D,C,B,A,p,o;y[z>>5]|=128<<(24-z%32);y[((z+64>>9)<<4)+15]=z;for(var B=0;B<y.length;B+=16){K=r[0];J=r[1];I=r[2];G=r[3];F=r[4];E=r[5];D=r[6];C=r[7];for(var A=0;A<64;A++){if(A<16){s[A]=y[A+B]}else{var n=s[A-15],u=s[A-2],M=((n<<25)|(n>>>7))^((n<<14)|(n>>>18))^(n>>>3),L=((u<<15)|(u>>>17))^((u<<13)|(u>>>19))^(u>>>10);s[A]=M+(s[A-7]>>>0)+L+(s[A-16]>>>0)}var t=F&E^~F&D,k=K&J^K&I^J&I,x=((K<<30)|(K>>>2))^((K<<19)|(K>>>13))^((K<<10)|(K>>>22)),v=((F<<26)|(F>>>6))^((F<<21)|(F>>>11))^((F<<7)|(F>>>25));p=(C>>>0)+v+t+(a[A])+(s[A]>>>0);o=x+k;C=D;D=E;E=F;F=G+p;G=I;I=J;J=K;K=p+o}r[0]+=K;r[1]+=J;r[2]+=I;r[3]+=G;r[4]+=F;r[5]+=E;r[6]+=D;r[7]+=C}return r};d._blocksize=16})();

var base64 = (function () {    var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";    var obj = {        /**         * Encodes a string in base64         * @param {String} input The string to encode in base64.         */        encode: function (input) {            var output = "";            var chr1, chr2, chr3;            var enc1, enc2, enc3, enc4;            var i = 0;            do {                chr1 = input.charCodeAt(i++);                chr2 = input.charCodeAt(i++);                chr3 = input.charCodeAt(i++);                enc1 = chr1 >> 2;                enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);                enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);                enc4 = chr3 & 63;                if (isNaN(chr2)) {                    enc3 = enc4 = 64;                } else if (isNaN(chr3)) {                    enc4 = 64;                }                output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) +                    keyStr.charAt(enc3) + keyStr.charAt(enc4);            } while (i < input.length);            return output;        },        /**         * Decodes a base64 string.         * @param {String} input The string to decode.         */        decode: function (input) {            var output = "";            var chr1, chr2, chr3;            var enc1, enc2, enc3, enc4;            var i = 0;            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");            do {                enc1 = keyStr.indexOf(input.charAt(i++));                enc2 = keyStr.indexOf(input.charAt(i++));                enc3 = keyStr.indexOf(input.charAt(i++));                enc4 = keyStr.indexOf(input.charAt(i++));                chr1 = (enc1 << 2) | (enc2 >> 4);                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);                chr3 = ((enc3 & 3) << 6) | enc4;                output = output + String.fromCharCode(chr1);                if (enc3 != 64) {                    output = output + String.fromCharCode(chr2);                }                if (enc4 != 64) {                    output = output + String.fromCharCode(chr3);                }            } while (i < input.length);            return output;        }    };    return obj;})();

/**
 * JDSU Custom method to convert decimal values to hexa values 
 * 
 * @param decimalValue
 * @param padding
 * 
 * @returns the hexa value of the given decimal value 
 */
function decimalToHex(decimalValue, padding) 
{
    var hex = Number(decimalValue).toString(16);
    padding = typeof (padding) === "undefined" || padding === null ? padding = 2 : padding;

    while (hex.length < padding) 
    {
        hex = "0" + hex;
    }

    return hex;
}

/**
 * JDSU Custom method to hash the given string with SHA256
 * 
 * @param stringToHash The string to hash with SHA256
 * 
 * @returns The string hash with SHA256 with hexa values
 */
function hashSHA256( stringToHash )
{
	var stringHashed = "";
    var hashArray = Crypto.SHA256(stringToHash,{asBytes:true})
    var len = hashArray.length
    for (var i=0; i<len; i++) 
    {
        if (i in hashArray) 
        {
            var decimalValue = hashArray[i];
            stringHashed += decimalToHex(decimalValue);
        }
    }
    
    return stringHashed;
}

/**
 * Encode string
 * 
 * @param stringToHash
 * @returns encoded string
 */
function encodeString( stringToHash )
{
	var possible = "?!;._-";
	var stringHashed = "";
    var stringEncoded = base64.encode(stringToHash)
    var len = stringEncoded.length
    for (var i=0; i<len; i++) 
    {
        stringHashed += stringEncoded.charAt(i) + possible.charAt(Math.floor(Math.random() * possible.length));
    }
    
    return stringHashed;
}