<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\view;

use app\serviceshelper\otdr\SMTUfomFileUtil;
use app\util\SMTIOException;

/**
 * Flush the file buffer for the given ufom file name.
 *
 * @author Sylvain Desplat
 */
class SMTUfomFileDownloadPage implements SMTIPage
{
	private $FILES_ALLOWED_FOR_DOWNLOAD = array('sor','csv','info','tar.gz','tar','gz' );
	private $DIRECTORIES_ALLOWED_FOR_DOWNLOAD = array(SMTUfomFileUtil::OTU_UFOM_DIR, SMTUfomFileUtil::OTU_UFOM_DIR_TEMP);
	
	protected $fileName;
	
	/**
	 * Only a few type of files are allowed to be downloaded
	 *
	 * @param string $fileName
	 * @return boolean
	 */
	function checkFileExtension($fileName)
	{
		$ext = pathinfo($fileName, PATHINFO_EXTENSION);
		return in_array($ext, $this->FILES_ALLOWED_FOR_DOWNLOAD);
	}
	
	/**
	 * Only a few directories are allowed for download
	 *
	 * @param string $fileName
	 * @return boolean
	 */
	function checkDirectory($fileName)
	{
		$dir = pathinfo($fileName, PATHINFO_DIRNAME).'/';
		// 		SMTLogger::getInstance()->trace($dir);
		return in_array($dir, $this->DIRECTORIES_ALLOWED_FOR_DOWNLOAD);
	}
	/**
	 * Construct the builder of otdr trace file.
	 * 
	 * @param string $fileName
	 * 
	 */
	function __construct( $fileName )
	{
		$this->fileName = $fileName;
	}

	/**
	 * Flush the otdr trace buffer for the given otdr trace file name
	 *
	 */
	function generatePage()
	{	    
	    //test file exists:
		if( $this->checkFileExtension($this->fileName) && $this->checkDirectory($this->fileName) && ($handle = fopen($this->fileName ,"rb")) != FALSE )
        {            
        	//open buffering
         	header('Content-Type: application/octet-stream;');
         	header('Content-Disposition: attachment; filename="'.basename( $this->fileName ).'";');
         	header('Cache-Control: no-cache, must-revalidate');
         	header('Expires: 0');         	
        	ob_start();            
            while ( !feof($handle) ) 
            {
                echo fread($handle , 8192 );
            }            
            fclose($handle);     

            //end buffering and flush
            return ob_end_flush();
        }        
        else
        {
        	throw new SMTIOException( SMTIOException::FILE_NOT_FOUND, rawurlencode(basename($this->fileName)) );
        }        
	}
}
?>