<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2013. All rights reserved.
// *********************************************************
namespace app\view;

use app\http\SMTSessionDirectoryUtil;
use app\serviceshelper\maintenance\SMTOtuDebug;
use app\serviceshelper\monitoring\SMTGpsRoute;
use app\util\SMTIOException;


/**
 * Flush the snapshot buffer.
 *
 * @author Sylvain Desplat
 */
class SMTFileDownloadPage implements SMTIPage
{
	private $fileName;
	
	const DOWNLOAD_TOKEN = "downloadToken";
	
	private $FILES_ALLOWED_FOR_DOWNLOAD = array('gz','tar.gz','log','tar','kml','kmz');
	//kml alarm/autotest/backup/snapshot and mib/kml/
	private $DIRECTORIES_ALLOWED_FOR_DOWNLOAD = array(SMTSessionDirectoryUtil::SMART_OTU_TEMP_DIR,'/acterna/user//harddisk/otu/autotest/','/user//harddisk/otu/autotest/','/user//harddisk/','/acterna/user//harddisk/',SMTOtuDebug::SNAPSHOT_DIR,SMTGpsRoute::GPS_ROUTE_DIR);
	
	/**
	 * Construct the builder to download the given file.
	 * 
	 * @param string $fileName
	 * 
	 */
	function __construct( $fileName )
	{
		$this->fileName = $fileName;
	}
	
	/**
	 * Only a few type of files are allowed to be downloaded
	 * 
	 * @param string $fileName
	 * @return boolean
	 */
	function checkFileExtension($fileName)
	{
		$ext= pathinfo($fileName, PATHINFO_EXTENSION);
// 		SMTLogger::getInstance()->trace($fileName);
		return in_array($ext, $this->FILES_ALLOWED_FOR_DOWNLOAD);
	}

	/**
	 * Only a few directories are allowed for download
	 *
	 * @param string $fileName
	 * @return boolean
	 */
	function checkDirectory($fileName)
	{
		$dir = pathinfo($fileName, PATHINFO_DIRNAME).'/';
// 		SMTLogger::getInstance()->trace($dir);
		return in_array($dir, $this->DIRECTORIES_ALLOWED_FOR_DOWNLOAD);
	}
	
	/**
	 * Flush the file buffer
	 *
	 */
	function generatePage()
	{	    
	    //test file exists:
		if ( file_exists($this->fileName) && $this->checkFileExtension($this->fileName) && $this->checkDirectory($this->fileName) )
        {
            header('Content-Description: File Transfer');
         	header('Content-Type: application/octet-stream');
         	header('Content-Disposition: attachment; filename="'.basename( $this->fileName ).'"');
         	header('Content-Length: ' . filesize($this->fileName));
         	header("Content-Transfer-Encoding: binary");
         	header('Cache-Control: no-cache, must-revalidate');
         	header('Expires: 0');
         	//open buffering
        	ob_start();            
        	readfile($this->fileName);

            //end buffering and flush
            return ob_end_flush();
        }        
        else
        {
        	throw new SMTIOException( SMTIOException::FILE_NOT_FOUND, rawurlencode(basename($this->fileName)) );
        }        
	}
}
?>