<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\system;

use app\util\SMTRwDto;

/**
 * Date-time dto with timezone
 * 
 * @author Sylvain Desplat 
 */
class SMTDateTimeDto extends SMTRwDto
{
    /**
     * Timestamp in seconds with time zone offset included (NOT UTC)
     *
     * @var integer
     */
    protected $timestamp;
    
    
    /**
     * Time zone offset in seconds
     * 
     * @var integer
     */
    protected $timezoneSec;
    
    /**
     * Time zone name (generic)
     * 
     * @var string
     */
    protected $timezoneName;   
    
    /**
     * Whether time zone is in DST period
     * 
     * @var boolean
     */
    protected $isTimezoneDst = FALSE;
    
    /**
     * Time zone offset in seconds
     * 
     * @return integer
     */
    public function getTimezoneSec()
    {
        return intval($this->timezoneSec);
    }
    
    /**
     * Time zone name (generic)
     * 
     * @return string
     */
    public function getTimezoneName()
    {
    	return $this->timezoneName;
    }
    
    /**
     * Timestamp in seconds with timezone offset included
     * 
     * @return number Timestamp in seconds with timezone included
     */
    public function getTimestamp()
    {
    	return $this->timestamp;
    }

    /**
     * Whether the timezone is in the DST period
     *
     * @return boolean Whether the timezone is in the DST period
     */
    public function isTimezoneDst()
    {
    	return $this->isTimezoneDst;
    }
    
    /**
     * Serialize as Json data the user object.<br>
     *
     * @return $objectProperties the object properties serialized as a Json string.
     */
    function getJsonData()
    {
    	$objectProperties = get_object_vars($this);
    	$this->serializeObjectAsJsonData( $objectProperties );
    	return $objectProperties;
    }
    
    /**
     * Returns Dto class name.
     *
     * @return string the dtop class name
     */
    function getDtoClassName()
    {
    	return get_class();
    }
    
    /**
     * Create the Dto from a Json Dto in an array
     *
     * @param array $json_array json data in an array
     *
     * @return SMTDateTimeDto
     */
    static function getInstance( array &$json_array )
    {
    	return self::forge( get_class(), $json_array );
    }    
}

?>