<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI Solutions
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI Solutions
// Copyright JDSU 2017. All rights reserved.
// *********************************************************
namespace app\serviceshelper\media;

use app\serviceshelper\SMTServiceHelper;

use app\parser\SMTOtuApi;
use app\services\setup\SMTOnmsiServerListDto;
use app\services\setup\SMTOnmsiServerDto;
use app\util\SMTUtil;

/**
 *
 * @author Sylvain Desplat
 *
 */
class SMTServer extends SMTServiceHelper
{    
	
	const TSC_STATUS_INDEX = 0;
	const MAIN_INDEX = 1;
	const BACKUP_INDEX = 2;
	
	const MAIN = 'MAIN';
	const BACKUP = 'BACKUP';
	
	/**
	 * 
	 */
	function testONMSiConnection(SMTOnmsiServerDto $server)
	{
		//TODO
		//test connection from OTU application to ONMSi server
		
		//send a test alarm
		if ( $server->isActive() )
		{
			$cmd_test_media = sprintf(SMTOtuApi::CMD_media_test, self::MAIN);
			$this->send($cmd_test_media."\n");
		}
	}
	
	/**
	 * Fetch all onmsi server configuration
	 *
	 * @return \app\services\setup\SMTOnmsiServerListDto
	 */
	function retrieveServerConf()
	{
		$onmsiServerListDto = new SMTOnmsiServerListDto();
		
		$activeServerIndex = $this->getActiveServer();
		$tsc1Active = FALSE;
		$tsc2Active = FALSE;
		$tsc3Active = FALSE;
		switch ($activeServerIndex)
		{
			case 0:
				$tsc1Active = TRUE;
				break;
			case 1:
				$tsc2Active = TRUE;
				break;
			case 2:
				$tsc3Active = TRUE;
				break;				
			default:
				break;
		}
		
		$onmsiServerListDto->setSshStrong( $this->isSsh_Strong() );
		
		$serverDto = $this->retrieveServer( 1, $tsc1Active );
		if ($serverDto != NULL)
		{
			$onmsiServerListDto->addServer($serverDto);
			if ( $serverDto->hasBackupRoute() )
			{
				$onmsiServerListDto->setBackupRoute(TRUE);
			}			
		}
		
		$serverDto2 = $this->retrieveServer( 2, $tsc2Active );
		if ($serverDto2 != NULL)
		{
			$onmsiServerListDto->addServer($serverDto2);
			if ( $serverDto2->hasBackupRoute() )
			{
				$onmsiServerListDto->setBackupRoute(TRUE);
			}
		}
		
		$serverDto3 = $this->retrieveServer( 3, $tsc3Active );
		if ($serverDto3 != NULL)
		{
			$onmsiServerListDto->addServer($serverDto3);
			if ( $serverDto3->hasBackupRoute() )
			{
				$onmsiServerListDto->setBackupRoute(TRUE);
			}
		}
		
		return $onmsiServerListDto;
	}
	
// 	function getONMSiServerAddressArray($tsc)
// 	{
// 		//ONMSi SERVER ADDRESS
// 		$cmd_get_onms_address = sprintf(SMTOtuApi::CMD_get_onms_address, $tsc);
// 		$this->sendReceive($cmd_get_onms_address);
		
// 		$onms_address = $socket->msg_string;
		
// 		$tmp_array = splitString(",",trim($onms_address));
// 		removeQuotesInArray( $tmp_array );
// 		$onmsi_ip = new onmsi_Address();
		
// 		$onmsi_ip->setTSCStatus( trim( trim( $tmp_array[0], "\"" ) ) );
// 		$onmsi_ip->setAddressMain( trim( trim( $tmp_array[1], "\"" ) ) );
// 		$onmsi_ip->setAddressBackup( trim( trim( $tmp_array[2], "\"" ) ) );
		
// 		$cmd_get_onms_name = sprintf(SMTOtuApi::CMD_get_onms_name, $tsc);
// 		$socket->send_receive( $cmd_get_onms_name."\n",0,SHORT_TIME_OUT_READING);
// 		$onms_name = $socket->msg_string;
		
// 		$tmp_array = splitString(",",trim($onms_name));
// 		removeQuotesInArray( $tmp_array );
		
// 		$onmsi_ip->setServerNameMain( trim( trim( $tmp_array[1], "\"" ) ) );
// 		$onmsi_ip->setServerNameBackup( trim( trim( $tmp_array[2], "\"" ) ) );
		
// 		return $onmsi_ip;
// 	}
	
	/**
	 * Fetch the onmsi server configuration
	 *
	 * @param integer $serverIndex (1 or 2)
	 * @param Boolean $active
	 *
	 * @return \app\services\setup\SMTOnmsiServerDto
	 */
	function retrieveServer( $serverIndex, $active = FALSE)
	{
		$serverDto = NULL;
		
		//look for  ,"  sequence to explode the string into an array $serverArray
		$serverString = $this->sendReceive( SMTOtuApi::getOnmsiServerAddress($serverIndex) );
		
		//remove spaces in array values
		$serverArray = SMTUtil::splitStringByComma( $serverString );
		
		if ( ($serverArray != NULL)&& is_array($serverArray) && ($serverArray[self::TSC_STATUS_INDEX]!= "") && ($serverArray[self::TSC_STATUS_INDEX]!= SMTOtuApi::RES_OFF) && ($serverArray[self::TSC_STATUS_INDEX]!= SMTOtuApi::RES_UNKNOWN) /*&& ($serverArray[self::MAIN_INDEX] != SMTOtuApi::RES_NONE) && ($serverArray[self::MAIN_INDEX] != SMTOtuApi::RES_UNKNOWN_AF)*/)
		{
			$serverDto = new SMTOnmsiServerDto();
			$serverDto->setIndex($serverIndex);
			$serverDto->setMainRouteServerIp($serverArray[self::MAIN_INDEX]);
			$serverDto->setBackupRouteServerIp($serverArray[self::BACKUP_INDEX]);
		
			//look for  ,"  sequence to explode the string into an array $serverArray
			$serverString = $this->sendReceive( SMTOtuApi::getOnmsiServerName($serverIndex) );
			
			//remove spaces in array values
			$serverArray = SMTUtil::splitStringByComma( $serverString );
			
			if ( ($serverArray != NULL) && is_array($serverArray) && ($serverArray[self::TSC_STATUS_INDEX]!= "") && ($serverArray[self::TSC_STATUS_INDEX]!= SMTOtuApi::RES_UNKNOWN) )
			{	
				if ( ($serverArray[self::MAIN_INDEX] != "") && ($serverArray[self::MAIN_INDEX] != SMTOtuApi::RES_NONE) && ($serverArray[self::MAIN_INDEX] != SMTOtuApi::RES_UNKNOWN_AF) && ($serverArray[self::MAIN_INDEX] != "" ) )
				{
					$serverDto->setMainRouteServerName($serverArray[self::MAIN_INDEX]);
				}
				if (count($serverArray) > self::BACKUP_INDEX )
				{
					if ( ($serverArray[self::BACKUP_INDEX] != "") && ($serverArray[self::BACKUP_INDEX] != SMTOtuApi::RES_NONE) && ($serverArray[self::BACKUP_INDEX] != SMTOtuApi::RES_UNKNOWN_AF) && ($serverArray[self::BACKUP_INDEX] != "" ) )
					{
						$serverDto->setBackupRouteServerName($serverArray[self::BACKUP_INDEX]);
					}
				}
			}
			
  			$serverDto->setIsActive($active);

		}
		
		return $serverDto;
	}  
	
	
	/**
	 * Get the active server name
	 * @return the active server id (0 , 1 or -1)
	 */
	function getActiveServer()
	{
		//ONMSi ACTIVE SERVER
		$activeServer = $this->sendReceive(SMTOtuApi::CMD_get_active_server);		
		
		return $activeServer;
	}    
	
	/**
	 * Whether Ssh Strong is setup on ONMSi
	 * @return TRUE if Ssh Strong is setup on ONMSi
	 */
	function isSsh_Strong()
	{
		$onmsiServerSshPersonalization = $this->sendReceive(SMTOtuApi::getSsh_Personalization());
		return strcasecmp( 'SSH_STRONG', $onmsiServerSshPersonalization) == 0;
	}
	
}



?>