<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of VIAVI
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from VIAVI
// Copyright JDSU 2016. All rights reserved.
// *********************************************************
namespace app\serviceshelper\maintenance;

use app\serviceshelper\SMTServiceHelper;
use app\util\SMTIOException;
use app\util\SMTLogger;
use app\util\SMTUtil;
use app\parser\SMTOtuApi;
use app\services\maintenance\SMTVpnDto;

/**
 *
 * @author Sylvain Desplat
 */
class SMTVpn extends SMTServiceHelper
{
    const COPY_VPN_FILE_CMD = "sudo /usr/lib/jdsu/scripts/smartotu_copy_files.sh %s vpn";
    
    /**
     * Install VPN.
     *
     * @param $filename string The name of the vpn file
     * @param $fullPath string The full path name of the temporary file
     * @throws \Exception if process fails
     */
    function installVpn($fileName, $fullPath)
    {
        $success = -1;
        $output = "";
        
        try
        {
            if ( file_exists( $fullPath) )
            {
                $command = sprintf(self::COPY_VPN_FILE_CMD, SMTUtil::escapeShellArgUtf8($fullPath) );
                SMTLogger::getInstance()->trace( sprintf("command: %s.", $command ), SMTLogger::DEBUG);
                
                // update vpn file
                $value = exec ($command, $output, $success);  
                // 0 -> update vpn OK, otherwise KO
                if ($success !== 0)
                {
                    throw new SMTIOException(SMTIOException::COPY_FAILURE, 'failed to copy uploaded vpn file %s', $fileName);
                }
                else 
                {
                    $this->getContext()->getLogger()->trace( sprintf("Successfully installed vpn, with vpn file name: %s ,output %s, success %s.", $value, $fileName, $success) );
                }
            }
            else
            {
                throw new SMTIOException(SMTIOException::FILE_NOT_FOUND, sprintf("uploaded VPN file %s not found",$fileName) );
            }
        }
        catch ( \Exception $e )
        {
            //remove invalid file
            unlink($fullPath);
            
            SMTLogger::getInstance()->traceException( $e );
            throw $e;
        }
        
        //always remove file after installation
        unlink($fullPath);
    }
    
    /**
     * Returns the vpn file name
     *
     * @return $vpn the Vpn file name
     */
    function retrieveVpn()
    {
        $vpn = new SMTVpnDto();
        try
        {
            $vpnFile = $this->sendReceive(SMTOtuApi::getVpnFileCommand());
            if (strlen($vpnFile) > 0)
            {
                $vpn->setVpnFile($vpnFile);
            }

        }
        catch ( \Exception $e )
        {
            SMTLogger::getInstance()->traceException( $e );
        }
        
        return $vpn;
    }
    
    /**
     * Delete the vpn file
     *
     */
    function deleteVpn()
    {
       $this->send(SMTOtuApi::getDisableVpnCommand());
    }
    
    /**
     * Aply the vpn file
     *
     */
    function applyVpn()
    {
        $this->send(SMTOtuApi::getActivateVpnCommand());
    }
}
?>