<?php
// *********************************************************
// NOTICE: All rights reserved. This material contains the
// trade secrets and confidential information of JDSU
// which embody substantial creative effort,
// ideas and expressions. No part of this material may be
// reproduced or transmitted in any form or by any means,
// electronic, mechanical, optical or otherwise, including
// photocopying and recording or in connection with any
// information storage or retrieval system, without
// specific written permission from JDSU
// Copyright JDSU 2012. All rights reserved.
// *********************************************************
namespace app\serviceshelper\ethernet;

use app\util\SMTException;

/**
 * Ethernet service exception
 * 
 * @author Sylvain Desplat
 *
 */
class SMTEthernetException extends SMTException
{
    const ERROR_INVALID_CONFIG = "ERROR_INVALID_CONFIG";
    const ERROR_INVALID_HOST_NAME = "ERROR_INVALID_HOST_NAME";
    const ERROR_INVALID_IPV4 = "ERROR_INVALID_IPV4";
    const ERROR_INVALID_IPV6 = "ERROR_INVALID_IPV6";
    const ERROR_INVALID_IPV4GATEWAY = "ERROR_INVALID_IPV4GATEWAY";
    const ERROR_INVALID_IPV4SUBNET = "ERROR_INVALID_IPV4SUBNET";
    const ERROR_INVALID_IPV6GATEWAY = "ERROR_INVALID_IPV6GATEWAY";
    
    /**
     *
     * @param string $code integer error code
     * @param string $message detailed message
     */    
    function __construct( $code = NULL, $message = NULL )
    {
    	parent::__construct( $code, $message );
    }
    
    /**
     * Get error codes label for tracing without error codes.
     *
     * @return string
     */
    public function getErrorLabel()
    {
    	return $this->getErrorCode();
    }
    
    /**
     * Translates exception error code
     * 
     * @param string $code The exception error code
     * 
     * @return string the exception message
     */
    public function decodeMessage( $code )
    {
        $errorMessage = MSG_ERROR_MEDIA;
        
        switch( $code )
        {
            case self::ERROR_INVALID_CONFIG:
                $errorMessage = MSG_ERROR_INVALID_CONFIG;
                break;
            case self::ERROR_INVALID_HOST_NAME:
            	$errorMessage = MSG_ERROR_INVALID_HOST_NAME;
            	break;          
        	case self::ERROR_INVALID_IPV4:
        		$errorMessage = MSG_ERROR_INVALID_IPV4;
        		break;
    		case self::ERROR_INVALID_IPV6:
    			$errorMessage = MSG_ERROR_INVALID_IPV6;
    			break;
			case self::ERROR_INVALID_IPV4GATEWAY:
				$errorMessage = MSG_ERROR_INVALID_IPV4GATEWAY;
				break;
			case self::ERROR_INVALID_IPV6GATEWAY:
				$errorMessage = MSG_ERROR_INVALID_IPV6GATEWAY;
				break;
			case self::ERROR_INVALID_IPV4SUBNET:
				$errorMessage = MSG_ERROR_INVALID_IPV4SUBNET;
				break;                
            default:
                break;
        }
        return $errorMessage;
    }
}

?>